/*
 * Decompiled with CFR 0.152.
 */
package rene.lister;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.PrintWriter;
import rene.gui.CloseFrame;
import rene.lister.Element;
import rene.lister.ListerPanel;
import rene.lister.StringElement;

public class Lister
extends Panel
implements AdjustmentListener {
    public ListerPanel L = new ListerPanel(this);
    Scrollbar Vertical;
    Scrollbar Horizontal;

    public Lister(boolean bl, boolean bl2) {
        this.setLayout(new BorderLayout());
        this.add("Center", this.L);
        if (bl) {
            this.Vertical = new Scrollbar(1, 0, 100, 0, 1100);
            this.add("East", this.Vertical);
            this.Vertical.addAdjustmentListener(this);
        }
        if (bl2) {
            this.Horizontal = new Scrollbar(0, 0, 100, 0, 1100);
            this.add("South", this.Horizontal);
            this.Horizontal.addAdjustmentListener(this);
        }
    }

    public Lister() {
        this(true, true);
    }

    public void setScrollbars(double d2, double d3, double d4, double d5) {
        if (this.Vertical != null) {
            int n = (int)(d3 * 1000.0);
            int n2 = 1000 + n;
            int n3 = (int)(d2 * 1000.0);
            this.Vertical.setValues(n3, n, 0, n2);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.Vertical != null && adjustmentEvent.getSource() == this.Vertical) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: {
                    this.L.up(1);
                    break;
                }
                case 2: {
                    this.L.down(1);
                    break;
                }
                case 4: {
                    this.L.pageUp();
                    break;
                }
                case 3: {
                    this.L.pageDown();
                    break;
                }
                default: {
                    int n = this.Vertical.getVisibleAmount();
                    int n2 = this.Vertical.getMaximum();
                    int n3 = this.Vertical.getValue();
                    this.L.setVerticalPos((double)n3 / (double)(n2 - n));
                    break;
                }
            }
        } else if (this.Horizontal != null && adjustmentEvent.getSource() == this.Horizontal) {
            int n = this.Horizontal.getValue();
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: {
                    n += 10;
                    break;
                }
                case 2: {
                    n -= 10;
                    break;
                }
                case 4: {
                    n += 50;
                    break;
                }
                case 3: {
                    n -= 50;
                }
            }
            this.L.setHorizontalPos((double)n / 1000.0);
            this.Horizontal.setValue(n);
        }
    }

    public ListerPanel getLister() {
        return this.L;
    }

    public void addActionListener(ActionListener actionListener) {
        this.L.addActionListener(actionListener);
    }

    public void updateDisplay() {
        this.L.repaint();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.L.removeActionListener(actionListener);
    }

    public void clear() {
        this.L.clear();
    }

    public void addElement(Element element) {
        this.L.add(element);
    }

    public int getSelectedIndex() {
        if (this.L.Selected.size() > 0) {
            return (Integer)this.L.Selected.elementAt(0);
        }
        return -1;
    }

    public String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.L.getElementAt(n).getElementString();
    }

    public int[] getSelectedIndices() {
        int[] nArray = new int[this.L.Selected.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)this.L.Selected.elementAt(i);
        }
        return nArray;
    }

    public void showLast() {
        this.L.showLast();
    }

    public void setMode(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.L.MultipleSelection = bl;
        this.L.EasyMultipleSelection = bl2;
        this.L.ReportSingleClick = bl3;
        this.L.RightMouseClick = bl4;
    }

    public void save(PrintWriter printWriter) {
        this.L.save(printWriter);
    }

    public void select(int n) {
    }

    public void addElement(String string, Color color) {
        this.addElement(new StringElement(string, color));
    }

    public void addElement(String string) {
        this.addElement(new StringElement(string));
    }

    public static void main(String[] stringArray) {
        CloseFrame closeFrame = new CloseFrame("Test");
        closeFrame.setSize(300, 400);
        closeFrame.setLocation(200, 200);
        closeFrame.setLayout(new BorderLayout());
        Lister lister = new Lister(true, true);
        closeFrame.add("Center", lister);
        for (int i = 0; i < 1000; ++i) {
            lister.getLister().add(new StringElement("-------------- This is line number: " + i, new Color(0, 0, i % 256)));
        }
        closeFrame.setVisible(true);
    }

    public void setState(int n) {
        this.L.setState(n);
    }

    public void setListingBackground(Color color) {
        this.L.setListingBackground(color);
    }
}

