// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import {
  ArrayBufferDataStream,
  FfiConverter,
  FfiConverterArrayBuffer,
  FfiConverterInt8,
  FfiConverterUInt8,
  FfiConverterInt16,
  FfiConverterUInt16,
  FfiConverterInt32,
  FfiConverterUInt32,
  FfiConverterInt64,
  FfiConverterUInt64,
  FfiConverterFloat32,
  FfiConverterFloat64,
  FfiConverterBoolean,
  FfiConverterBytes,
  FfiConverterString,
  UniFFICallbackHandler,
  UniFFICallbackMethodHandler,
  UniFFIError,
  UniFFIInternalError,
  UniFFITypeError,
  constructUniffiObject,
  handleRustResult,
  uniffiObjectPtr,
} from "moz-src:///toolkit/components/uniffi-js/js/UniFFI.sys.mjs";

// Objects intended to be used in the unit tests
export var UnitTestObjs = {
    uniffiObjectPtr,
};



export class FfiConverterTypeJsonValue extends FfiConverter {
    static lift(value) {
        return FfiConverterString.lift(value);
    }

    static lower(value) {
        return FfiConverterString.lower(value);
    }

    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    }

    static read(dataStream) {
        const builtinVal = FfiConverterString.read(dataStream);
        return builtinVal;
    }

    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }

    static checkType(value) {
        if (value === null || value === undefined) {
            throw new TypeError("value is null or undefined");
        }
    }
}
// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeJsonValue extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeJsonValue.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeJsonValue.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeJsonValue.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeJsonValue.computeSize(value)
    }
}
/**
 * StorageValueChange
 */
export class StorageValueChange {
    constructor(
        {
            key, 
            oldValue, 
            newValue
        } = {
            key: undefined, 
            oldValue: undefined, 
            newValue: undefined
        }
    ) {
        try {
            FfiConverterString.checkType(key)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("key");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeJsonValue.checkType(oldValue)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("oldValue");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeJsonValue.checkType(newValue)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("newValue");
            }
            throw e;
        }
        /**
         * key
         */
        this.key = key;
        /**
         * oldValue
         */
        this.oldValue = oldValue;
        /**
         * newValue
         */
        this.newValue = newValue;
    }

    equals(other) {
        return (
            this.key == other.key
            && this.oldValue == other.oldValue
            && this.newValue == other.newValue
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeStorageValueChange extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new StorageValueChange({
            key: FfiConverterString.read(dataStream),
            oldValue: FfiConverterOptionalTypeJsonValue.read(dataStream),
            newValue: FfiConverterOptionalTypeJsonValue.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.key);
        FfiConverterOptionalTypeJsonValue.write(dataStream, value.oldValue);
        FfiConverterOptionalTypeJsonValue.write(dataStream, value.newValue);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.key);
        totalSize += FfiConverterOptionalTypeJsonValue.computeSize(value.oldValue);
        totalSize += FfiConverterOptionalTypeJsonValue.computeSize(value.newValue);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof StorageValueChange)) {
            throw new UniFFITypeError(`Expected 'StorageValueChange', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.key);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".key");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeJsonValue.checkType(value.oldValue);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".oldValue");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeJsonValue.checkType(value.newValue);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".newValue");
            }
            throw e;
        }
    }
}
// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeStorageValueChange extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeStorageValueChange.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeStorageValueChange.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeStorageValueChange.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeStorageValueChange.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}
/**
 * StorageChanges
 */
export class StorageChanges {
    constructor(
        {
            changes
        } = {
            changes: undefined
        }
    ) {
        try {
            FfiConverterSequenceTypeStorageValueChange.checkType(changes)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("changes");
            }
            throw e;
        }
        /**
         * changes
         */
        this.changes = changes;
    }

    equals(other) {
        return (
            this.changes == other.changes
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeStorageChanges extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new StorageChanges({
            changes: FfiConverterSequenceTypeStorageValueChange.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterSequenceTypeStorageValueChange.write(dataStream, value.changes);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterSequenceTypeStorageValueChange.computeSize(value.changes);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof StorageChanges)) {
            throw new UniFFITypeError(`Expected 'StorageChanges', found '${typeof value}'`);
        }
        try {
            FfiConverterSequenceTypeStorageValueChange.checkType(value.changes);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".changes");
            }
            throw e;
        }
    }
}
/**
 * SyncedExtensionChange
 */
export class SyncedExtensionChange {
    constructor(
        {
            extId, 
            changes
        } = {
            extId: undefined, 
            changes: undefined
        }
    ) {
        try {
            FfiConverterString.checkType(extId)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("extId");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(changes)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("changes");
            }
            throw e;
        }
        /**
         * extId
         */
        this.extId = extId;
        /**
         * changes
         */
        this.changes = changes;
    }

    equals(other) {
        return (
            this.extId == other.extId
            && this.changes == other.changes
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSyncedExtensionChange extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SyncedExtensionChange({
            extId: FfiConverterString.read(dataStream),
            changes: FfiConverterString.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.extId);
        FfiConverterString.write(dataStream, value.changes);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.extId);
        totalSize += FfiConverterString.computeSize(value.changes);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SyncedExtensionChange)) {
            throw new UniFFITypeError(`Expected 'SyncedExtensionChange', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.extId);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".extId");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.changes);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".changes");
            }
            throw e;
        }
    }
}

/**
 * QuotaReason
 */
export const QuotaReason = {
    /**
     * TOTAL_BYTES
     */
    TOTAL_BYTES: 0,
    /**
     * ITEM_BYTES
     */
    ITEM_BYTES: 1,
    /**
     * MAX_ITEMS
     */
    MAX_ITEMS: 2,
};
Object.freeze(QuotaReason);

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeQuotaReason extends FfiConverterArrayBuffer {
    static #validValues = Object.values(QuotaReason)

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match the Rust scaffolding
        switch (dataStream.readInt32()) {
            case 1:
                return QuotaReason.TOTAL_BYTES
            case 2:
                return QuotaReason.ITEM_BYTES
            case 3:
                return QuotaReason.MAX_ITEMS
            default:
                throw new UniFFITypeError("Unknown QuotaReason variant");
        }
    }

    static write(dataStream, value) {
        // Use sequential indices (1-based) for the wire format to match the Rust scaffolding
        if (value === QuotaReason.TOTAL_BYTES) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === QuotaReason.ITEM_BYTES) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === QuotaReason.MAX_ITEMS) {
            dataStream.writeInt32(3);
            return;
        }
        throw new UniFFITypeError("Unknown QuotaReason variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for QuotaReason`);
      }
    }
}

/**
 * WebExtStorageApiError
 */
export class WebExtStorageApiError extends Error {}


/**
 * UnexpectedError
 */
export class UnexpectedError extends WebExtStorageApiError {

    constructor(
        reason,
        ...params
    ) {
        const message = `reason: ${ reason }`;
        super(message, ...params);
        this.reason = reason;
    }
    toString() {
        return `UnexpectedError: ${super.toString()}`
    }
}

/**
 * JsonError
 */
export class JsonError extends WebExtStorageApiError {

    constructor(
        reason,
        ...params
    ) {
        const message = `reason: ${ reason }`;
        super(message, ...params);
        this.reason = reason;
    }
    toString() {
        return `JsonError: ${super.toString()}`
    }
}

/**
 * QuotaError
 */
export class QuotaError extends WebExtStorageApiError {

    constructor(
        reason,
        ...params
    ) {
        const message = `reason: ${ reason }`;
        super(message, ...params);
        this.reason = reason;
    }
    toString() {
        return `QuotaError: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeWebExtStorageApiError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new UnexpectedError(
                    FfiConverterString.read(dataStream)
                    );
            case 2:
                return new JsonError(
                    FfiConverterString.read(dataStream)
                    );
            case 3:
                return new QuotaError(
                    FfiConverterTypeQuotaReason.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown WebExtStorageApiError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof UnexpectedError) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        if (value instanceof JsonError) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        if (value instanceof QuotaError) {
            totalSize += FfiConverterTypeQuotaReason.computeSize(value.reason);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown WebExtStorageApiError variant");
    }
    static write(dataStream, value) {
        if (value instanceof UnexpectedError) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        if (value instanceof JsonError) {
            dataStream.writeInt32(2);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        if (value instanceof QuotaError) {
            dataStream.writeInt32(3);
            FfiConverterTypeQuotaReason.write(dataStream, value.reason);
            return;
        }
        throw new UniFFITypeError("Unknown WebExtStorageApiError variant");
    }

    static errorClass = WebExtStorageApiError;
}
export class FfiConverterTypeGuid extends FfiConverter {
    static lift(value) {
        return FfiConverterString.lift(value);
    }

    static lower(value) {
        return FfiConverterString.lower(value);
    }

    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    }

    static read(dataStream) {
        const builtinVal = FfiConverterString.read(dataStream);
        return builtinVal;
    }

    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }

    static checkType(value) {
        if (value === null || value === undefined) {
            throw new TypeError("value is null or undefined");
        }
    }
}
// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceString extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterString.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterString.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterString.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterString.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}


// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeGuid extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeGuid.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeGuid.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeGuid.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeGuid.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}
// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalString extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

/**
 * WebExtStorageBridgedEngineInterface
 */
export class WebExtStorageBridgedEngineInterface {
    /**
     * apply
     * @returns {Promise<Array.<string>>}}
     */
    async apply() {
      throw Error("apply not implemented");
    }
    /**
     * ensureCurrentSyncId
     * @param {string} newSyncId
     * @returns {Promise<string>}}
     */
    async ensureCurrentSyncId(
        newSyncId) {
      throw Error("ensureCurrentSyncId not implemented");
    }
    /**
     * lastSync
     * @returns {Promise<number>}}
     */
    async lastSync() {
      throw Error("lastSync not implemented");
    }
    /**
     * prepareForSync
     * @param {string} clientData
     */
    async prepareForSync(
        clientData) {
      throw Error("prepareForSync not implemented");
    }
    /**
     * reset
     */
    async reset() {
      throw Error("reset not implemented");
    }
    /**
     * resetSyncId
     * @returns {Promise<string>}}
     */
    async resetSyncId() {
      throw Error("resetSyncId not implemented");
    }
    /**
     * setLastSync
     * @param {number} lastSync
     */
    async setLastSync(
        lastSync) {
      throw Error("setLastSync not implemented");
    }
    /**
     * setUploaded
     * @param {number} serverModifiedMillis
     * @param {Array.<Guid>} guids
     */
    async setUploaded(
        serverModifiedMillis, 
        guids) {
      throw Error("setUploaded not implemented");
    }
    /**
     * storeIncoming
     * @param {Array.<string>} incoming
     */
    async storeIncoming(
        incoming) {
      throw Error("storeIncoming not implemented");
    }
    /**
     * syncFinished
     */
    async syncFinished() {
      throw Error("syncFinished not implemented");
    }
    /**
     * syncId
     * @returns {Promise<?string>}}
     */
    async syncId() {
      throw Error("syncId not implemented");
    }
    /**
     * syncStarted
     */
    async syncStarted() {
      throw Error("syncStarted not implemented");
    }
    /**
     * wipe
     */
    async wipe() {
      throw Error("wipe not implemented");
    }

}

/**
 * WebExtStorageBridgedEngine
 */
export class WebExtStorageBridgedEngine extends WebExtStorageBridgedEngineInterface {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        super();
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an int using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }

    /**
     * apply
     * @returns {Promise<Array.<string>>}}
     */
    async apply() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            93, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_apply
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            FfiConverterSequenceString.lift.bind(FfiConverterSequenceString),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * ensureCurrentSyncId
     * @param {string} newSyncId
     * @returns {Promise<string>}}
     */
    async ensureCurrentSyncId(
        newSyncId) {
       
        FfiConverterString.checkType(newSyncId);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            94, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_ensure_current_sync_id
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
            FfiConverterString.lower(newSyncId),
        )
        return handleRustResult(
            result,
            FfiConverterString.lift.bind(FfiConverterString),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * lastSync
     * @returns {Promise<number>}}
     */
    async lastSync() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            95, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_last_sync
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            FfiConverterInt64.lift.bind(FfiConverterInt64),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * prepareForSync
     * @param {string} clientData
     */
    async prepareForSync(
        clientData) {
       
        FfiConverterString.checkType(clientData);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            96, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_prepare_for_sync
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
            FfiConverterString.lower(clientData),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * reset
     */
    async reset() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            97, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_reset
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * resetSyncId
     * @returns {Promise<string>}}
     */
    async resetSyncId() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            98, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_reset_sync_id
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            FfiConverterString.lift.bind(FfiConverterString),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * setLastSync
     * @param {number} lastSync
     */
    async setLastSync(
        lastSync) {
       
        FfiConverterInt64.checkType(lastSync);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            99, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_set_last_sync
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
            FfiConverterInt64.lower(lastSync),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * setUploaded
     * @param {number} serverModifiedMillis
     * @param {Array.<Guid>} guids
     */
    async setUploaded(
        serverModifiedMillis, 
        guids) {
       
        FfiConverterInt64.checkType(serverModifiedMillis);
        FfiConverterSequenceTypeGuid.checkType(guids);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            100, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_set_uploaded
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
            FfiConverterInt64.lower(serverModifiedMillis),
            FfiConverterSequenceTypeGuid.lower(guids),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * storeIncoming
     * @param {Array.<string>} incoming
     */
    async storeIncoming(
        incoming) {
       
        FfiConverterSequenceString.checkType(incoming);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            101, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_store_incoming
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
            FfiConverterSequenceString.lower(incoming),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * syncFinished
     */
    async syncFinished() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            102, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_sync_finished
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * syncId
     * @returns {Promise<?string>}}
     */
    async syncId() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            103, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_sync_id
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            FfiConverterOptionalString.lift.bind(FfiConverterOptionalString),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * syncStarted
     */
    async syncStarted() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            104, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_sync_started
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * wipe
     */
    async wipe() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            105, // uniffi_webext_storage_fn_method_webextstoragebridgedengine_wipe
            FfiConverterTypeWebExtStorageBridgedEngine.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeWebExtStorageBridgedEngine extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new WebExtStorageBridgedEngine(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'WebExtStorageBridgedEngine' instance");
        }
        return ptr;
    }

    static lowerReceiver(value) {
        // This works exactly the same as lower for non-trait interfaces
        return this.lower(value);
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointer(13));
    }

    static write(dataStream, value) {
        dataStream.writePointer(13, this.lower(value));
    }

    static computeSize(value) {
        return 8;
    }
}



// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeSyncedExtensionChange extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeSyncedExtensionChange.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeSyncedExtensionChange.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeSyncedExtensionChange.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeSyncedExtensionChange.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

/**
 * WebExtStorageStoreInterface
 */
export class WebExtStorageStoreInterface {
    /**
     * bridgedEngine
     * @returns {Promise<WebExtStorageBridgedEngine>}}
     */
    async bridgedEngine() {
      throw Error("bridgedEngine not implemented");
    }
    /**
     * clear
     * @param {string} extId
     * @returns {Promise<StorageChanges>}}
     */
    async clear(
        extId) {
      throw Error("clear not implemented");
    }
    /**
     * close
     */
    async close() {
      throw Error("close not implemented");
    }
    /**
     * get
     * @param {string} extId
     * @param {JsonValue} keys
     * @returns {Promise<JsonValue>}}
     */
    async get(
        extId, 
        keys) {
      throw Error("get not implemented");
    }
    /**
     * getBytesInUse
     * @param {string} extId
     * @param {JsonValue} keys
     * @returns {Promise<number>}}
     */
    async getBytesInUse(
        extId, 
        keys) {
      throw Error("getBytesInUse not implemented");
    }
    /**
     * getKeys
     * @param {string} extId
     * @returns {Promise<JsonValue>}}
     */
    async getKeys(
        extId) {
      throw Error("getKeys not implemented");
    }
    /**
     * getSyncedChanges
     * @returns {Promise<Array.<SyncedExtensionChange>>}}
     */
    async getSyncedChanges() {
      throw Error("getSyncedChanges not implemented");
    }
    /**
     * remove
     * @param {string} extId
     * @param {JsonValue} keys
     * @returns {Promise<StorageChanges>}}
     */
    async remove(
        extId, 
        keys) {
      throw Error("remove not implemented");
    }
    /**
     * set
     * @param {string} extId
     * @param {JsonValue} val
     * @returns {Promise<StorageChanges>}}
     */
    async set(
        extId, 
        val) {
      throw Error("set not implemented");
    }

}

/**
 * WebExtStorageStore
 */
export class WebExtStorageStore extends WebExtStorageStoreInterface {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        super();
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an int using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * init
     * @param {string} path
     * @returns {Promise<WebExtStorageStore>}}
     */
    static async init(
        path) {
       
        FfiConverterString.checkType(path);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            106, // uniffi_webext_storage_fn_constructor_webextstoragestore_new
            FfiConverterString.lower(path),
        )
        return handleRustResult(
            result,
            FfiConverterTypeWebExtStorageStore.lift.bind(FfiConverterTypeWebExtStorageStore),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * bridgedEngine
     * @returns {Promise<WebExtStorageBridgedEngine>}}
     */
    async bridgedEngine() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            107, // uniffi_webext_storage_fn_method_webextstoragestore_bridged_engine
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            FfiConverterTypeWebExtStorageBridgedEngine.lift.bind(FfiConverterTypeWebExtStorageBridgedEngine),
            null,
        )
    }

    /**
     * clear
     * @param {string} extId
     * @returns {Promise<StorageChanges>}}
     */
    async clear(
        extId) {
       
        FfiConverterString.checkType(extId);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            108, // uniffi_webext_storage_fn_method_webextstoragestore_clear
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
            FfiConverterString.lower(extId),
        )
        return handleRustResult(
            result,
            FfiConverterTypeStorageChanges.lift.bind(FfiConverterTypeStorageChanges),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * close
     */
    async close() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            109, // uniffi_webext_storage_fn_method_webextstoragestore_close
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            (result) => undefined,
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * get
     * @param {string} extId
     * @param {JsonValue} keys
     * @returns {Promise<JsonValue>}}
     */
    async get(
        extId, 
        keys) {
       
        FfiConverterString.checkType(extId);
        FfiConverterTypeJsonValue.checkType(keys);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            110, // uniffi_webext_storage_fn_method_webextstoragestore_get
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
            FfiConverterString.lower(extId),
            FfiConverterTypeJsonValue.lower(keys),
        )
        return handleRustResult(
            result,
            FfiConverterTypeJsonValue.lift.bind(FfiConverterTypeJsonValue),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * getBytesInUse
     * @param {string} extId
     * @param {JsonValue} keys
     * @returns {Promise<number>}}
     */
    async getBytesInUse(
        extId, 
        keys) {
       
        FfiConverterString.checkType(extId);
        FfiConverterTypeJsonValue.checkType(keys);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            111, // uniffi_webext_storage_fn_method_webextstoragestore_get_bytes_in_use
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
            FfiConverterString.lower(extId),
            FfiConverterTypeJsonValue.lower(keys),
        )
        return handleRustResult(
            result,
            FfiConverterUInt64.lift.bind(FfiConverterUInt64),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * getKeys
     * @param {string} extId
     * @returns {Promise<JsonValue>}}
     */
    async getKeys(
        extId) {
       
        FfiConverterString.checkType(extId);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            112, // uniffi_webext_storage_fn_method_webextstoragestore_get_keys
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
            FfiConverterString.lower(extId),
        )
        return handleRustResult(
            result,
            FfiConverterTypeJsonValue.lift.bind(FfiConverterTypeJsonValue),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * getSyncedChanges
     * @returns {Promise<Array.<SyncedExtensionChange>>}}
     */
    async getSyncedChanges() {
       
        const result = await UniFFIScaffolding.callAsyncWrapper(
            113, // uniffi_webext_storage_fn_method_webextstoragestore_get_synced_changes
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
        )
        return handleRustResult(
            result,
            FfiConverterSequenceTypeSyncedExtensionChange.lift.bind(FfiConverterSequenceTypeSyncedExtensionChange),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * remove
     * @param {string} extId
     * @param {JsonValue} keys
     * @returns {Promise<StorageChanges>}}
     */
    async remove(
        extId, 
        keys) {
       
        FfiConverterString.checkType(extId);
        FfiConverterTypeJsonValue.checkType(keys);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            114, // uniffi_webext_storage_fn_method_webextstoragestore_remove
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
            FfiConverterString.lower(extId),
            FfiConverterTypeJsonValue.lower(keys),
        )
        return handleRustResult(
            result,
            FfiConverterTypeStorageChanges.lift.bind(FfiConverterTypeStorageChanges),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

    /**
     * set
     * @param {string} extId
     * @param {JsonValue} val
     * @returns {Promise<StorageChanges>}}
     */
    async set(
        extId, 
        val) {
       
        FfiConverterString.checkType(extId);
        FfiConverterTypeJsonValue.checkType(val);
        const result = await UniFFIScaffolding.callAsyncWrapper(
            115, // uniffi_webext_storage_fn_method_webextstoragestore_set
            FfiConverterTypeWebExtStorageStore.lowerReceiver(this),
            FfiConverterString.lower(extId),
            FfiConverterTypeJsonValue.lower(val),
        )
        return handleRustResult(
            result,
            FfiConverterTypeStorageChanges.lift.bind(FfiConverterTypeStorageChanges),
            FfiConverterTypeWebExtStorageApiError.lift.bind(FfiConverterTypeWebExtStorageApiError),
        )
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeWebExtStorageStore extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new WebExtStorageStore(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'WebExtStorageStore' instance");
        }
        return ptr;
    }

    static lowerReceiver(value) {
        // This works exactly the same as lower for non-trait interfaces
        return this.lower(value);
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointer(14));
    }

    static write(dataStream, value) {
        dataStream.writePointer(14, this.lower(value));
    }

    static computeSize(value) {
        return 8;
    }
}



