# 2025-01-14 Triage Log

A quiet week with little change to the actual compiler performance. The biggest compiler regression was quickly recognized and reverted. 

Triage done by **@rylev**.
Revision range: [0f1e965f..1ab85fbd](https://perf.rust-lang.org/?start=0f1e965fec3bc2f97b932e9dd8e85fca6d7faadc&end=1ab85fbd7474e8ce84d5283548f21472860de3e2&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%   | [0.1%, 1.8%]    | 21    |
| Regressions ❌ <br /> (secondary)  | 0.5%   | [0.0%, 2.0%]    | 35    |
| Improvements ✅ <br /> (primary)   | -0.8%  | [-2.7%, -0.3%]  | 6     |
| Improvements ✅ <br /> (secondary) | -10.2% | [-27.8%, -0.1%] | 13    |
| All ❌✅ (primary)                 | 0.2%   | [-2.7%, 1.8%]   | 27    |


4 Regressions, 3 Improvements, 3 Mixed; 3 of them in rollups
44 artifact comparisons made in total

#### Regressions

Master bootstrap update [#135268](https://github.com/rust-lang/rust/pull/135268) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ec12cd8436aab693d8847b3077c26fe2de4ed661&end=251206c27b619ccf3a08e2ac4c525dc343f08492&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 3     |
- Probably just noise, and if not, it's not really worth investigating.


mir_transform: implement `#[rustc_force_inline]` [#134082](https://github.com/rust-lang/rust/pull/134082) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=336209eef13882bd1e211b24779584cb7ef911eb&end=b1a7dfb91106018f47ed9dc9b27aee1977682868&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.2%  | [-0.1%, 0.3%]  | 11    |
- Looks like some regressions snuck back in since the last run - I'm unsure if something happened in a rebase to reintroduce them. 
- The actual regressions are much smaller than the original perf run, and I don't think they're big enough to demand an investigation.


Add #[inline] to copy_from_slice [#135384](https://github.com/rust-lang/rust/pull/135384) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=627513a764a696b59bb2679cc1731a197a088a1d&end=48a426eca9df23b24b3559e545cf88dee61d4de9&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [1.1%, 1.1%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [1.1%, 1.1%] | 1     |
- From the PR "Small chaotic effect is expected, small binary size improvements oddly line up with the effect I was going for. Seems unlikely they're connected though, I wouldn't be surprised to see a different list of affected scenarios after merge."


Rollup of 4 pull requests [#135438](https://github.com/rust-lang/rust/pull/135438) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2ae9916816a448fcaab3b2da461de754eda0055a&end=1ab85fbd7474e8ce84d5283548f21472860de3e2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [0.9%, 1.6%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.4%  | [0.4%, 0.4%]   | 1     |
- https://github.com/rust-lang/rust/pull/135426 is the offending PR. Working with the author on a solution.


#### Improvements

Rollup of 6 pull requests [#135260](https://github.com/rust-lang/rust/pull/135260) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a580b5c379b4fca50dfe5afc0fc0ce00921e4e00&end=e26ff2f9086fc449b963df578f8641c31846abe6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 4     |


Remove special-casing for argument patterns in MIR typeck (attempt to fix perf regression of  #133858) [#135273](https://github.com/rust-lang/rust/pull/135273) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=67951d946a158bc70949150ca06265e912752096&end=b44e14f762fd4062faeba97f8f2bc470298ec1ac&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -3.0% | [-17.4%, -0.2%] | 16    |
| Improvements ✅ <br /> (secondary) | -     | -               | 0     |
| All ❌✅ (primary)                 | -3.0% | [-17.4%, -0.2%] | 16    |


Add an InstSimplify for repetitive array expressions [#135274](https://github.com/rust-lang/rust/pull/135274) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a2d7c8144f3f237612b37420fe2b6b08408d5b1d&end=7e4077d06fc073442c567d58885b47ed2c5121b8&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -      | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -      | -               | 0     |
| Improvements ✅ <br /> (primary)   | -      | -               | 0     |
| Improvements ✅ <br /> (secondary) | -14.7% | [-27.9%, -1.3%] | 9     |
| All ❌✅ (primary)                 | -      | -               | 0     |


#### Mixed

`best_blame_constraint`: Blame better constraints when the region graph has cycles from invariance or `'static` [#133858](https://github.com/rust-lang/rust/pull/133858) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c87288a7d2f03625a813df6d3bfe43c09ad4f5a&end=6afee111c2faf86ba884ea748967130abad37b52&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.2%  | [0.1%, 21.0%]  | 17    |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 3.2%  | [0.1%, 21.0%]  | 17    |
- Partially reverted in https://github.com/rust-lang/rust/pull/135273


[mir-opt] GVN some more transmute cases [#133324](https://github.com/rust-lang/rust/pull/133324) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=65d7296fc9868af121adb5e07358a3815a80a7a1&end=b6b8361bce8561fb8786ad33ca1abfdf4bc487b6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.1%, 1.4%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-3.0%, -0.2%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 7     |
| All ❌✅ (primary)                 | -0.3% | [-3.0%, 1.4%]  | 14    |
- [Original perf run was deemed acceptable](https://github.com/rust-lang/rust/pull/133324#issuecomment-2520872151) and the final perf run wasn't as bad.


Rollup of 6 pull requests [#135357](https://github.com/rust-lang/rust/pull/135357) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7e4077d06fc073442c567d58885b47ed2c5121b8&end=ce55b2052db2c9d6deb2dbc5cb2f56d163515a99&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.6%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 2.0%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.5%, -0.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.5%, 0.6%]  | 5     |

