% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-dictionary.R
\name{label_dictionary}
\alias{label_dictionary}
\title{Labels from lookup tables}
\usage{
label_dictionary(dictionary = character(), nomatch = NULL)
}
\arguments{
\item{dictionary}{A named character vector of labels. The names are expected
to match the breaks, and the values become the labels.}

\item{nomatch}{A string to label breaks that do not match any name in
\code{dictionary}. When \code{NULL} (default), the breaks are not translated but are
kept as-is.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Use \code{label_dictionary()} for looking up succinct breaks in a named character
vector giving complete labels.
}
\examples{
# Example lookup table
lut <- c(
  "4" = "four wheel drive",
  "r" = "rear wheel drive",
  "f" = "front wheel drive"
)

# Typical usage
demo_discrete(c("4", "r", "f"), labels = label_dictionary(lut))
# By default, extra values ('w') will remain as-is
demo_discrete(c("4", "r", "f", "w"), labels = label_dictionary(lut))
# Alternatively, you can relabel extra values
demo_discrete(
  c("4", "r", "f", "w"),
  labels = label_dictionary(lut, nomatch = "unknown")
)
}
\seealso{
Other labels for discrete scales: 
\code{\link{label_glue}()},
\code{\link{label_parse}()},
\code{\link{label_wrap}()}
}
\concept{labels for discrete scales}
