% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_transformed.R
\name{dist_transformed}
\alias{dist_transformed}
\title{Modify a distribution with a transformation}
\usage{
dist_transformed(dist, transform, inverse)
}
\arguments{
\item{dist}{A univariate distribution vector.}

\item{transform}{A function used to transform the distribution. This
transformation should be monotonic over appropriate domain.}

\item{inverse}{The inverse of the \code{transform} function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

A transformed distribution applies a monotonic transformation to an existing
distribution. This is useful for creating derived distributions such as
log-normal (exponential transformation of normal), or other custom
transformations of base distributions.

The \code{\link[=density]{density()}}, \code{\link[=mean]{mean()}}, and \code{\link[=variance]{variance()}} methods are approximate as
they are based on numerical derivatives.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_transformed.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_transformed.html}

Let \eqn{Y = g(X)} where \eqn{X} is the base distribution with
transformation function \code{transform} = \eqn{g} and \code{inverse} = \eqn{g^{-1}}.
The transformation \eqn{g} must be monotonic over the support of \eqn{X}.

\strong{Support}: \eqn{g(S_X)} where \eqn{S_X} is the support of \eqn{X}

\strong{Mean}: Approximated numerically using a second-order Taylor expansion:

\deqn{
    E(Y) \approx g(\mu_X) + \frac{1}{2}g''(\mu_X)\sigma_X^2
  }{
    E(Y) ~= g(mu_X) + (1/2) g''(mu_X) sigma_X^2
  }

where \eqn{\mu_X} and \eqn{\sigma_X^2} are the mean and variance of the
base distribution \eqn{X}, and \eqn{g''} is the second derivative of the
transformation. The derivative is computed numerically using
\code{\link[numDeriv:hessian]{numDeriv::hessian()}}.

\strong{Variance}: Approximated numerically using the delta method:

\deqn{
    \mathrm{Var}(Y) \approx [g'(\mu_X)]^2\sigma_X^2 + \frac{1}{2}[g''(\mu_X)\sigma_X^2]^2
  }{
    Var(Y) ~= [g'(mu_X)]^2 sigma_X^2 + (1/2) [g''(mu_X) sigma_X^2]^2
  }

where \eqn{g'} is the first derivative (Jacobian) computed numerically
using \code{\link[numDeriv:jacobian]{numDeriv::jacobian()}}.

\strong{Probability density function (p.d.f)}: Using the change of variables
formula:

\deqn{
    f_Y(y) = f_X(g^{-1}(y)) \left|\frac{d}{dy}g^{-1}(y)\right|
  }{
    f_Y(y) = f_X(g^(-1)(y)) |d/dy g^(-1)(y)|
  }

where \eqn{f_X} is the p.d.f. of the base distribution and the Jacobian
\eqn{|d/dy \, g^{-1}(y)|} is computed numerically using
\code{\link[numDeriv:jacobian]{numDeriv::jacobian()}}.

\strong{Cumulative distribution function (c.d.f)}:

For monotonically increasing \eqn{g}:
\deqn{
    F_Y(y) = F_X(g^{-1}(y))
  }{
    F_Y(y) = F_X(g^(-1)(y))
  }

For monotonically decreasing \eqn{g}:
\deqn{
    F_Y(y) = 1 - F_X(g^{-1}(y))
  }{
    F_Y(y) = 1 - F_X(g^(-1)(y))
  }

where \eqn{F_X} is the c.d.f. of the base distribution.

\strong{Quantile function}: The inverse of the c.d.f.

For monotonically increasing \eqn{g}:
\deqn{
    Q_Y(p) = g(Q_X(p))
  }{
    Q_Y(p) = g(Q_X(p))
  }

For monotonically decreasing \eqn{g}:
\deqn{
    Q_Y(p) = g(Q_X(1-p))
  }{
    Q_Y(p) = g(Q_X(1-p))
  }

where \eqn{Q_X} is the quantile function of the base distribution.
}
\examples{
# Create a log normal distribution
dist <- dist_transformed(dist_normal(0, 0.5), exp, log)
density(dist, 1) # dlnorm(1, 0, 0.5)
cdf(dist, 4) # plnorm(4, 0, 0.5)
quantile(dist, 0.1) # qlnorm(0.1, 0, 0.5)
generate(dist, 10) # rlnorm(10, 0, 0.5)

}
\seealso{
\code{\link[numDeriv:jacobian]{numDeriv::jacobian()}}, \code{\link[numDeriv:hessian]{numDeriv::hessian()}}
}
