/*
 * Copyright (c) 2024, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8341495
 * @summary Test for crash caused by format specifier in startup script
 * @modules jdk.compiler/com.sun.tools.javac.api
 *          jdk.compiler/com.sun.tools.javac.main
 *          jdk.jshell/jdk.internal.jshell.tool
 * @library /tools/lib
 * @build toolbox.ToolBox
 * @build KullaTesting Compiler
 * @run junit StartupWithFormatSpecifierTest
 */

import java.nio.file.Path;

import org.junit.jupiter.api.Test;

public class StartupWithFormatSpecifierTest extends ReplToolTesting {

    @Test
    public void testStartupWithFormatSpecifier() {
        Compiler compiler = new Compiler();
        String startupScript = "String.format(\"This is a %s.\", \"test\");";
        Path startupFile = compiler.getPath("StartupFileOption/startup.txt");
        compiler.writeToFile(startupFile, startupScript);
        test(new String[] { "--startup", startupFile.toString() },
                (a) -> assertCommandOutputContains(a, "/set start", startupScript)
        );
    }
}
