/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.tools.publicdataviewer;

import com.sourceforge.knecs.util.NSProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Namespace;

public class PublicDataProperties
extends Properties {
    private static final String PROPERTIES_RESOURCE = "publicdata.properties";
    private static PublicDataProperties mInstance = null;
    public static final String VERSION = "PublicDataVersion";
    public static final String CONFIG_FILE = "OntologyFile";
    public static final Namespace mDcNs = Namespace.getNamespace("dc", "http://purl.org/dc/elements/1.1/");
    public static final Namespace mCmcsNs = Namespace.getNamespace("cmcs", "http://purl.oclc.org/NET/cmcs/schema/");
    public static final Namespace mCmlNs = Namespace.getNamespace("cml", "http://www.xml-cml.org/schema/cml2/core");
    public static final Namespace mXlinkNs = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");

    protected PublicDataProperties() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_RESOURCE);
        try {
            super.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PublicDataProperties getPublicDataProperties() {
        if (mInstance == null) {
            mInstance = new PublicDataProperties();
        }
        return mInstance;
    }

    public static Vector getPropertyAsVector(String key) {
        Vector<String> propVec = null;
        String prop = PublicDataProperties.getPublicDataProperties().getProperty(key);
        if (prop != null) {
            propVec = new Vector<String>();
            StringTokenizer st = null;
            if (prop.startsWith("\\")) {
                String delim = prop.substring(1, 2);
                st = new StringTokenizer(prop.substring(2), delim);
            } else {
                st = new StringTokenizer(prop);
            }
            while (st.hasMoreTokens()) {
                propVec.add(st.nextToken().trim());
            }
        }
        return propVec;
    }

    public Vector getPropertyAsNSPropertyVector(String key) {
        Vector<NSProperty> propNameVec = null;
        Vector tmpVec = PublicDataProperties.getPropertyAsVector(key);
        if (tmpVec != null) {
            propNameVec = new Vector<NSProperty>(tmpVec.size());
            for (int i = 0; i < tmpVec.size(); ++i) {
                propNameVec.add(new NSProperty((String)tmpVec.get(i)));
            }
        }
        return propNameVec;
    }
}

