//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient contains the methods for the DatabaseSQLVulnerabilityAssessmentRuleBaselines group.
// Don't use this type directly, use NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient() instead.
type DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient creates a new instance of DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - parameters - The requested rule baseline resource.
//   - options - DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters for
//     the DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate method.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineInput, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleID, parameters, options)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineInput, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentRuleBaseline); err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Removes the database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - options - DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Delete
//     method.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteResponse, error) {
	var err error
	const operationName = "DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleID, options)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets a database's sql vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - options - DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Get
//     method.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetOptions) (DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	var err error
	const operationName = "DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleID, options)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) getHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentRuleBaseline); err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByBaselinePager - Gets a list of database's sql vulnerability assessment rule baselines.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineOptions contains the optional parameters for
//     the DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.NewListByBaselinePager method.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) NewListByBaselinePager(resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineOptions) *runtime.Pager[DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse] {
	return runtime.NewPager(runtime.PagingHandler[DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse]{
		More: func(page DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse) (DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.NewListByBaselinePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByBaselineCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, options)
			}, nil)
			if err != nil {
				return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse{}, err
			}
			return client.listByBaselineHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByBaselineCreateRequest creates the ListByBaseline request.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) listByBaselineCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByBaselineHandleResponse handles the ListByBaseline response.
func (client *DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) listByBaselineHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult); err != nil {
		return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse{}, err
	}
	return result, nil
}
