//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresqlflexibleservers

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAdministratorsClient creates a new instance of AdministratorsClient.
func (c *ClientFactory) NewAdministratorsClient() *AdministratorsClient {
	subClient, _ := NewAdministratorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBackupsClient creates a new instance of BackupsClient.
func (c *ClientFactory) NewBackupsClient() *BackupsClient {
	subClient, _ := NewBackupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCheckNameAvailabilityClient creates a new instance of CheckNameAvailabilityClient.
func (c *ClientFactory) NewCheckNameAvailabilityClient() *CheckNameAvailabilityClient {
	subClient, _ := NewCheckNameAvailabilityClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCheckNameAvailabilityWithLocationClient creates a new instance of CheckNameAvailabilityWithLocationClient.
func (c *ClientFactory) NewCheckNameAvailabilityWithLocationClient() *CheckNameAvailabilityWithLocationClient {
	subClient, _ := NewCheckNameAvailabilityWithLocationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConfigurationsClient creates a new instance of ConfigurationsClient.
func (c *ClientFactory) NewConfigurationsClient() *ConfigurationsClient {
	subClient, _ := NewConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabasesClient creates a new instance of DatabasesClient.
func (c *ClientFactory) NewDatabasesClient() *DatabasesClient {
	subClient, _ := NewDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFirewallRulesClient creates a new instance of FirewallRulesClient.
func (c *ClientFactory) NewFirewallRulesClient() *FirewallRulesClient {
	subClient, _ := NewFirewallRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFlexibleServerClient creates a new instance of FlexibleServerClient.
func (c *ClientFactory) NewFlexibleServerClient() *FlexibleServerClient {
	subClient, _ := NewFlexibleServerClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGetPrivateDNSZoneSuffixClient creates a new instance of GetPrivateDNSZoneSuffixClient.
func (c *ClientFactory) NewGetPrivateDNSZoneSuffixClient() *GetPrivateDNSZoneSuffixClient {
	subClient, _ := NewGetPrivateDNSZoneSuffixClient(c.credential, c.options)
	return subClient
}

// NewLocationBasedCapabilitiesClient creates a new instance of LocationBasedCapabilitiesClient.
func (c *ClientFactory) NewLocationBasedCapabilitiesClient() *LocationBasedCapabilitiesClient {
	subClient, _ := NewLocationBasedCapabilitiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLogFilesClient creates a new instance of LogFilesClient.
func (c *ClientFactory) NewLogFilesClient() *LogFilesClient {
	subClient, _ := NewLogFilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLtrBackupOperationsClient creates a new instance of LtrBackupOperationsClient.
func (c *ClientFactory) NewLtrBackupOperationsClient() *LtrBackupOperationsClient {
	subClient, _ := NewLtrBackupOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMigrationsClient creates a new instance of MigrationsClient.
func (c *ClientFactory) NewMigrationsClient() *MigrationsClient {
	subClient, _ := NewMigrationsClient(c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPostgreSQLManagementClient creates a new instance of PostgreSQLManagementClient.
func (c *ClientFactory) NewPostgreSQLManagementClient() *PostgreSQLManagementClient {
	subClient, _ := NewPostgreSQLManagementClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionClient creates a new instance of PrivateEndpointConnectionClient.
func (c *ClientFactory) NewPrivateEndpointConnectionClient() *PrivateEndpointConnectionClient {
	subClient, _ := NewPrivateEndpointConnectionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewQuotaUsagesClient creates a new instance of QuotaUsagesClient.
func (c *ClientFactory) NewQuotaUsagesClient() *QuotaUsagesClient {
	subClient, _ := NewQuotaUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewReplicasClient creates a new instance of ReplicasClient.
func (c *ClientFactory) NewReplicasClient() *ReplicasClient {
	subClient, _ := NewReplicasClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerCapabilitiesClient creates a new instance of ServerCapabilitiesClient.
func (c *ClientFactory) NewServerCapabilitiesClient() *ServerCapabilitiesClient {
	subClient, _ := NewServerCapabilitiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerThreatProtectionSettingsClient creates a new instance of ServerThreatProtectionSettingsClient.
func (c *ClientFactory) NewServerThreatProtectionSettingsClient() *ServerThreatProtectionSettingsClient {
	subClient, _ := NewServerThreatProtectionSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServersClient creates a new instance of ServersClient.
func (c *ClientFactory) NewServersClient() *ServersClient {
	subClient, _ := NewServersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualEndpointsClient creates a new instance of VirtualEndpointsClient.
func (c *ClientFactory) NewVirtualEndpointsClient() *VirtualEndpointsClient {
	subClient, _ := NewVirtualEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualNetworkSubnetUsageClient creates a new instance of VirtualNetworkSubnetUsageClient.
func (c *ClientFactory) NewVirtualNetworkSubnetUsageClient() *VirtualNetworkSubnetUsageClient {
	subClient, _ := NewVirtualNetworkSubnetUsageClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
