//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogic

import "time"

// APIDeploymentParameterMetadata - The API deployment parameter metadata.
type APIDeploymentParameterMetadata struct {
	// The description.
	Description *string

	// The display name.
	DisplayName *string

	// Indicates whether its required.
	IsRequired *bool

	// The type.
	Type *string

	// The visibility.
	Visibility *APIDeploymentParameterVisibility
}

// APIDeploymentParameterMetadataSet - The API deployment parameters metadata.
type APIDeploymentParameterMetadataSet struct {
	// The package content link parameter.
	PackageContentLink *APIDeploymentParameterMetadata

	// The package content link parameter.
	RedisCacheConnectionString *APIDeploymentParameterMetadata
}

// APIOperation - The api operation.
type APIOperation struct {
	// The resource location.
	Location *string

	// The api operations properties
	Properties *APIOperationPropertiesDefinition

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// APIOperationAnnotation - The Api Operation Annotation.
type APIOperationAnnotation struct {
	// The family.
	Family *string

	// The revision.
	Revision *int32

	// The status annotation.
	Status *StatusAnnotation
}

// APIOperationListResult - The list of managed API operations.
type APIOperationListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The api operation definitions for an API.
	Value []*APIOperation
}

// APIOperationPropertiesDefinition - The api operations properties
type APIOperationPropertiesDefinition struct {
	// The api reference.
	API *APIReference

	// The annotation of api operation.
	Annotation *APIOperationAnnotation

	// The description of the api operation.
	Description *string

	// The operation inputs definition schema.
	InputsDefinition *SwaggerSchema

	// Indicates whether the API operation is notification or not.
	IsNotification *bool

	// Indicates whether the API operation is webhook or not.
	IsWebhook *bool

	// Indicates whether the api operation is pageable.
	Pageable *bool

	// The operation responses definition schemas.
	ResponsesDefinition map[string]*SwaggerSchema

	// The summary of the api operation.
	Summary *string

	// The trigger type of api operation.
	Trigger *string

	// The trigger hint for the api operation.
	TriggerHint *string

	// The visibility of the api operation.
	Visibility *string
}

// APIReference - The Api reference.
type APIReference struct {
	// The brand color of the api.
	BrandColor *string

	// The tier.
	Category *APITier

	// The description of the api.
	Description *string

	// The display name of the api.
	DisplayName *string

	// The resource id.
	ID *string

	// The icon uri of the api.
	IconURI *string

	// The integration service environment reference.
	IntegrationServiceEnvironment *ResourceReference

	// The swagger of the api.
	Swagger any

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// APIResourceBackendService - The API backend service.
type APIResourceBackendService struct {
	// The service URL.
	ServiceURL *string
}

// APIResourceDefinitions - The Api resource definition.
type APIResourceDefinitions struct {
	// The modified swagger url.
	ModifiedSwaggerURL *string

	// The original swagger url.
	OriginalSwaggerURL *string
}

// APIResourceGeneralInformation - The API general information.
type APIResourceGeneralInformation struct {
	// The description.
	Description *string

	// The display name.
	DisplayName *string

	// The icon url.
	IconURL *string

	// The release tag.
	ReleaseTag *string

	// The terms of use url.
	TermsOfUseURL *string

	// The tier.
	Tier *APITier
}

// APIResourceMetadata - The api resource metadata.
type APIResourceMetadata struct {
	// The api type.
	APIType *APIType

	// The brand color.
	BrandColor *string

	// The connection type.
	ConnectionType *string

	// The connector deployment parameters metadata.
	DeploymentParameters *APIDeploymentParameterMetadataSet

	// The hide key.
	HideKey *string

	// The provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// The source.
	Source *string

	// The tags.
	Tags map[string]*string

	// The WSDL import method.
	WsdlImportMethod *WsdlImportMethod

	// The WSDL service.
	WsdlService *WsdlService
}

// APIResourcePolicies - The API resource policies.
type APIResourcePolicies struct {
	// The API level only policies XML as embedded content.
	Content *string

	// The content link to the policies.
	ContentLink *string
}

// APIResourceProperties - The API resource properties.
type APIResourceProperties struct {
	// The integration service environment reference.
	IntegrationServiceEnvironment *ResourceReference

	// READ-ONLY; The API definition.
	APIDefinitionURL *string

	// READ-ONLY; The api definitions.
	APIDefinitions *APIResourceDefinitions

	// READ-ONLY; The backend service.
	BackendService *APIResourceBackendService

	// READ-ONLY; The capabilities.
	Capabilities []*string

	// READ-ONLY; The category.
	Category *APITier

	// READ-ONLY; The connection parameters.
	ConnectionParameters map[string]any

	// READ-ONLY; The api general information.
	GeneralInformation *APIResourceGeneralInformation

	// READ-ONLY; The metadata.
	Metadata *APIResourceMetadata

	// READ-ONLY; The name
	Name *string

	// READ-ONLY; The policies for the API.
	Policies *APIResourcePolicies

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// READ-ONLY; The runtime urls.
	RuntimeUrls []*string
}

// AS2AcknowledgementConnectionSettings - The AS2 agreement acknowledgement connection settings.
type AS2AcknowledgementConnectionSettings struct {
	// REQUIRED; Indicates whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool

	// REQUIRED; Indicates whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool

	// REQUIRED; Indicates whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool

	// REQUIRED; Indicates whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool
}

// AS2AgreementContent - The integration account AS2 agreement content.
type AS2AgreementContent struct {
	// REQUIRED; The AS2 one-way receive agreement.
	ReceiveAgreement *AS2OneWayAgreement

	// REQUIRED; The AS2 one-way send agreement.
	SendAgreement *AS2OneWayAgreement
}

// AS2EnvelopeSettings - The AS2 agreement envelope settings.
type AS2EnvelopeSettings struct {
	// REQUIRED; The value indicating whether to auto generate file name.
	AutogenerateFileName *bool

	// REQUIRED; The template for file name.
	FileNameTemplate *string

	// REQUIRED; The message content type.
	MessageContentType *string

	// REQUIRED; The value indicating whether to suspend message on file name generation error.
	SuspendMessageOnFileNameGenerationError *bool

	// REQUIRED; The value indicating whether to transmit file name in mime header.
	TransmitFileNameInMimeHeader *bool
}

// AS2ErrorSettings - The AS2 agreement error settings.
type AS2ErrorSettings struct {
	// REQUIRED; The value indicating whether to resend message If MDN is not received.
	ResendIfMDNNotReceived *bool

	// REQUIRED; The value indicating whether to suspend duplicate message.
	SuspendDuplicateMessage *bool
}

// AS2MdnSettings - The AS2 agreement mdn settings.
type AS2MdnSettings struct {
	// REQUIRED; The signing or hashing algorithm.
	MicHashingAlgorithm *HashingAlgorithm

	// REQUIRED; The value indicating whether to send or request a MDN.
	NeedMDN *bool

	// REQUIRED; The value indicating whether to send inbound MDN to message box.
	SendInboundMDNToMessageBox *bool

	// REQUIRED; The value indicating whether to send the asynchronous MDN.
	SendMDNAsynchronously *bool

	// REQUIRED; The value indicating whether the MDN needs to be signed or not.
	SignMDN *bool

	// REQUIRED; The value indicating whether to sign the outbound MDN if optional.
	SignOutboundMDNIfOptional *bool

	// The disposition notification to header value.
	DispositionNotificationTo *string

	// The MDN text.
	MdnText *string

	// The receipt delivery URL.
	ReceiptDeliveryURL *string
}

// AS2MessageConnectionSettings - The AS2 agreement message connection settings.
type AS2MessageConnectionSettings struct {
	// REQUIRED; The value indicating whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool

	// REQUIRED; The value indicating whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool

	// REQUIRED; The value indicating whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool

	// REQUIRED; The value indicating whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool
}

// AS2OneWayAgreement - The integration account AS2 one-way agreement.
type AS2OneWayAgreement struct {
	// REQUIRED; The AS2 protocol settings.
	ProtocolSettings *AS2ProtocolSettings

	// REQUIRED; The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity

	// REQUIRED; The sender business identity
	SenderBusinessIdentity *BusinessIdentity
}

// AS2ProtocolSettings - The AS2 agreement protocol settings.
type AS2ProtocolSettings struct {
	// REQUIRED; The acknowledgement connection settings.
	AcknowledgementConnectionSettings *AS2AcknowledgementConnectionSettings

	// REQUIRED; The envelope settings.
	EnvelopeSettings *AS2EnvelopeSettings

	// REQUIRED; The error settings.
	ErrorSettings *AS2ErrorSettings

	// REQUIRED; The MDN settings.
	MdnSettings *AS2MdnSettings

	// REQUIRED; The message connection settings.
	MessageConnectionSettings *AS2MessageConnectionSettings

	// REQUIRED; The security settings.
	SecuritySettings *AS2SecuritySettings

	// REQUIRED; The validation settings.
	ValidationSettings *AS2ValidationSettings
}

// AS2SecuritySettings - The AS2 agreement security settings.
type AS2SecuritySettings struct {
	// REQUIRED; The value indicating whether to enable NRR for inbound decoded messages.
	EnableNRRForInboundDecodedMessages *bool

	// REQUIRED; The value indicating whether to enable NRR for inbound encoded messages.
	EnableNRRForInboundEncodedMessages *bool

	// REQUIRED; The value indicating whether to enable NRR for inbound MDN.
	EnableNRRForInboundMDN *bool

	// REQUIRED; The value indicating whether to enable NRR for outbound decoded messages.
	EnableNRRForOutboundDecodedMessages *bool

	// REQUIRED; The value indicating whether to enable NRR for outbound encoded messages.
	EnableNRRForOutboundEncodedMessages *bool

	// REQUIRED; The value indicating whether to enable NRR for outbound MDN.
	EnableNRRForOutboundMDN *bool

	// REQUIRED; The value indicating whether to send or request a MDN.
	OverrideGroupSigningCertificate *bool

	// The name of the encryption certificate.
	EncryptionCertificateName *string

	// The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
	SHA2AlgorithmFormat *string

	// The name of the signing certificate.
	SigningCertificateName *string
}

// AS2ValidationSettings - The AS2 agreement validation settings.
type AS2ValidationSettings struct {
	// REQUIRED; The value indicating whether to check for certificate revocation list on receive.
	CheckCertificateRevocationListOnReceive *bool

	// REQUIRED; The value indicating whether to check for certificate revocation list on send.
	CheckCertificateRevocationListOnSend *bool

	// REQUIRED; The value indicating whether to check for duplicate message.
	CheckDuplicateMessage *bool

	// REQUIRED; The value indicating whether the message has to be compressed.
	CompressMessage *bool

	// REQUIRED; The value indicating whether the message has to be encrypted.
	EncryptMessage *bool

	// REQUIRED; The encryption algorithm.
	EncryptionAlgorithm *EncryptionAlgorithm

	// REQUIRED; The number of days to look back for duplicate interchange.
	InterchangeDuplicatesValidityDays *int32

	// REQUIRED; The value indicating whether to override incoming message properties with those in agreement.
	OverrideMessageProperties *bool

	// REQUIRED; The value indicating whether the message has to be signed.
	SignMessage *bool

	// The signing algorithm.
	SigningAlgorithm *SigningAlgorithm
}

// AgreementContent - The integration account agreement content.
type AgreementContent struct {
	// The AS2 agreement content.
	AS2 *AS2AgreementContent

	// The EDIFACT agreement content.
	Edifact *EdifactAgreementContent

	// The X12 agreement content.
	X12 *X12AgreementContent
}

// ArtifactContentPropertiesDefinition - The artifact content properties definition.
type ArtifactContentPropertiesDefinition struct {
	// The artifact changed time.
	ChangedTime *time.Time

	// Anything
	Content any

	// The content link.
	ContentLink *ContentLink

	// The content type.
	ContentType *string

	// The artifact creation time.
	CreatedTime *time.Time

	// Anything
	Metadata any
}

// ArtifactProperties - The artifact properties definition.
type ArtifactProperties struct {
	// The artifact changed time.
	ChangedTime *time.Time

	// The artifact creation time.
	CreatedTime *time.Time

	// Anything
	Metadata any
}

// AssemblyCollection - A collection of assembly definitions.
type AssemblyCollection struct {
	Value []*AssemblyDefinition
}

// AssemblyDefinition - The assembly definition.
type AssemblyDefinition struct {
	// REQUIRED; The assembly properties.
	Properties *AssemblyProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// AssemblyProperties - The assembly properties definition.
type AssemblyProperties struct {
	// REQUIRED; The assembly name.
	AssemblyName *string

	// The assembly culture.
	AssemblyCulture *string

	// The assembly public key token.
	AssemblyPublicKeyToken *string

	// The assembly version.
	AssemblyVersion *string

	// The artifact changed time.
	ChangedTime *time.Time

	// Anything
	Content any

	// The content link.
	ContentLink *ContentLink

	// The content type.
	ContentType *string

	// The artifact creation time.
	CreatedTime *time.Time

	// Anything
	Metadata any
}

// AzureResourceErrorInfo - The azure resource error info.
type AzureResourceErrorInfo struct {
	// REQUIRED; The error code.
	Code *string

	// REQUIRED; The error message.
	Message *string

	// The error details.
	Details []*AzureResourceErrorInfo
}

// B2BPartnerContent - The B2B partner content.
type B2BPartnerContent struct {
	// The list of partner business identities.
	BusinessIdentities []*BusinessIdentity
}

// BatchConfiguration - The batch configuration resource definition.
type BatchConfiguration struct {
	// REQUIRED; The batch configuration properties.
	Properties *BatchConfigurationProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// BatchConfigurationCollection - A collection of batch configurations.
type BatchConfigurationCollection struct {
	Value []*BatchConfiguration
}

// BatchConfigurationProperties - The batch configuration properties definition.
type BatchConfigurationProperties struct {
	// REQUIRED; The name of the batch group.
	BatchGroupName *string

	// REQUIRED; The batch release criteria.
	ReleaseCriteria *BatchReleaseCriteria

	// The artifact changed time.
	ChangedTime *time.Time

	// The artifact creation time.
	CreatedTime *time.Time

	// Anything
	Metadata any
}

// BatchReleaseCriteria - The batch release criteria.
type BatchReleaseCriteria struct {
	// The batch size in bytes.
	BatchSize *int32

	// The message count.
	MessageCount *int32

	// The recurrence.
	Recurrence *WorkflowTriggerRecurrence
}

// BusinessIdentity - The integration account partner's business identity.
type BusinessIdentity struct {
	// REQUIRED; The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
	Qualifier *string

	// REQUIRED; The user defined business identity value.
	Value *string
}

// CallbackURL - The callback url.
type CallbackURL struct {
	// The URL value.
	Value *string
}

// ContentHash - The content hash.
type ContentHash struct {
	// The algorithm of the content hash.
	Algorithm *string

	// The value of the content hash.
	Value *string
}

// ContentLink - The content link.
type ContentLink struct {
	// The content link URI.
	URI *string

	// READ-ONLY; The content hash.
	ContentHash *ContentHash

	// READ-ONLY; The content size.
	ContentSize *int64

	// READ-ONLY; The content version.
	ContentVersion *string

	// READ-ONLY; The metadata.
	Metadata any
}

// Correlation - The correlation property.
type Correlation struct {
	// The client tracking id.
	ClientTrackingID *string
}

// EdifactAcknowledgementSettings - The Edifact agreement acknowledgement settings.
type EdifactAcknowledgementSettings struct {
	// REQUIRED; The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32

	// REQUIRED; The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32

	// REQUIRED; The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool

	// REQUIRED; The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool

	// REQUIRED; The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool

	// REQUIRED; The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool

	// REQUIRED; The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool

	// REQUIRED; The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool

	// REQUIRED; The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool

	// The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string

	// The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string
}

// EdifactAgreementContent - The Edifact agreement content.
type EdifactAgreementContent struct {
	// REQUIRED; The EDIFACT one-way receive agreement.
	ReceiveAgreement *EdifactOneWayAgreement

	// REQUIRED; The EDIFACT one-way send agreement.
	SendAgreement *EdifactOneWayAgreement
}

// EdifactDelimiterOverride - The Edifact delimiter override settings.
type EdifactDelimiterOverride struct {
	// REQUIRED; The component separator.
	ComponentSeparator *int32

	// REQUIRED; The data element separator.
	DataElementSeparator *int32

	// REQUIRED; The decimal point indicator.
	DecimalPointIndicator *EdifactDecimalIndicator

	// REQUIRED; The release indicator.
	ReleaseIndicator *int32

	// REQUIRED; The repetition separator.
	RepetitionSeparator *int32

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32

	// REQUIRED; The segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix

	// The message association assigned code.
	MessageAssociationAssignedCode *string

	// The message id.
	MessageID *string

	// The message release.
	MessageRelease *string

	// The message version.
	MessageVersion *string

	// The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string
}

// EdifactEnvelopeOverride - The Edifact envelope override settings.
type EdifactEnvelopeOverride struct {
	// The application password.
	ApplicationPassword *string

	// The association assigned code.
	AssociationAssignedCode *string

	// The controlling agency code.
	ControllingAgencyCode *string

	// The functional group id.
	FunctionalGroupID *string

	// The group header message release.
	GroupHeaderMessageRelease *string

	// The group header message version.
	GroupHeaderMessageVersion *string

	// The message association assigned code.
	MessageAssociationAssignedCode *string

	// The message id on which this envelope settings has to be applied.
	MessageID *string

	// The message release version on which this envelope settings has to be applied.
	MessageRelease *string

	// The message version on which this envelope settings has to be applied.
	MessageVersion *string

	// The receiver application id.
	ReceiverApplicationID *string

	// The receiver application qualifier.
	ReceiverApplicationQualifier *string

	// The sender application id.
	SenderApplicationID *string

	// The sender application qualifier.
	SenderApplicationQualifier *string

	// The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string
}

// EdifactEnvelopeSettings - The Edifact agreement envelope settings.
type EdifactEnvelopeSettings struct {
	// REQUIRED; The value indicating whether to apply delimiter string advice.
	ApplyDelimiterStringAdvice *bool

	// REQUIRED; The value indicating whether to create grouping segments.
	CreateGroupingSegments *bool

	// REQUIRED; The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool

	// REQUIRED; The group control number lower bound.
	GroupControlNumberLowerBound *int64

	// REQUIRED; The group control number upper bound.
	GroupControlNumberUpperBound *int64

	// REQUIRED; The interchange control number lower bound.
	InterchangeControlNumberLowerBound *int64

	// REQUIRED; The interchange control number upper bound.
	InterchangeControlNumberUpperBound *int64

	// REQUIRED; The value indicating whether the message is a test interchange.
	IsTestInterchange *bool

	// REQUIRED; The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool

	// REQUIRED; The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool

	// REQUIRED; The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool

	// REQUIRED; The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool

	// REQUIRED; The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int64

	// REQUIRED; The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int64

	// The application reference id.
	ApplicationReferenceID *string

	// The communication agreement id.
	CommunicationAgreementID *string

	// The functional group id.
	FunctionalGroupID *string

	// The group application password.
	GroupApplicationPassword *string

	// The group application receiver id.
	GroupApplicationReceiverID *string

	// The group application receiver qualifier.
	GroupApplicationReceiverQualifier *string

	// The group application sender id.
	GroupApplicationSenderID *string

	// The group application sender qualifier.
	GroupApplicationSenderQualifier *string

	// The group association assigned code.
	GroupAssociationAssignedCode *string

	// The group control number prefix.
	GroupControlNumberPrefix *string

	// The group control number suffix.
	GroupControlNumberSuffix *string

	// The group controlling agency code.
	GroupControllingAgencyCode *string

	// The group message release.
	GroupMessageRelease *string

	// The group message version.
	GroupMessageVersion *string

	// The interchange control number prefix.
	InterchangeControlNumberPrefix *string

	// The interchange control number suffix.
	InterchangeControlNumberSuffix *string

	// The processing priority code.
	ProcessingPriorityCode *string

	// The receiver internal identification.
	ReceiverInternalIdentification *string

	// The receiver internal sub identification.
	ReceiverInternalSubIdentification *string

	// The receiver reverse routing address.
	ReceiverReverseRoutingAddress *string

	// The recipient reference password qualifier.
	RecipientReferencePasswordQualifier *string

	// The recipient reference password value.
	RecipientReferencePasswordValue *string

	// The sender internal identification.
	SenderInternalIdentification *string

	// The sender internal sub identification.
	SenderInternalSubIdentification *string

	// The sender reverse routing address.
	SenderReverseRoutingAddress *string

	// The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string

	// The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string
}

// EdifactFramingSettings - The Edifact agreement framing settings.
type EdifactFramingSettings struct {
	// REQUIRED; The EDIFACT frame setting characterSet.
	CharacterSet *EdifactCharacterSet

	// REQUIRED; The component separator.
	ComponentSeparator *int32

	// REQUIRED; The data element separator.
	DataElementSeparator *int32

	// REQUIRED; The EDIFACT frame setting decimal indicator.
	DecimalPointIndicator *EdifactDecimalIndicator

	// REQUIRED; The protocol version.
	ProtocolVersion *int32

	// REQUIRED; The release indicator.
	ReleaseIndicator *int32

	// REQUIRED; The repetition separator.
	RepetitionSeparator *int32

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32

	// REQUIRED; The EDIFACT frame setting segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix

	// The character encoding.
	CharacterEncoding *string

	// The service code list directory version.
	ServiceCodeListDirectoryVersion *string
}

// EdifactMessageFilter - The Edifact message filter for odata query.
type EdifactMessageFilter struct {
	// REQUIRED; The message filter type.
	MessageFilterType *MessageFilterType
}

// EdifactMessageIdentifier - The Edifact message identifier.
type EdifactMessageIdentifier struct {
	// REQUIRED; The message id on which this envelope settings has to be applied.
	MessageID *string
}

// EdifactOneWayAgreement - The Edifact one way agreement.
type EdifactOneWayAgreement struct {
	// REQUIRED; The EDIFACT protocol settings.
	ProtocolSettings *EdifactProtocolSettings

	// REQUIRED; The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity

	// REQUIRED; The sender business identity
	SenderBusinessIdentity *BusinessIdentity
}

// EdifactProcessingSettings - The Edifact agreement protocol settings.
type EdifactProcessingSettings struct {
	// REQUIRED; The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool

	// REQUIRED; The value indicating whether to mask security information.
	MaskSecurityInfo *bool

	// REQUIRED; The value indicating whether to preserve interchange.
	PreserveInterchange *bool

	// REQUIRED; The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool

	// REQUIRED; The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool
}

// EdifactProtocolSettings - The Edifact agreement protocol settings.
type EdifactProtocolSettings struct {
	// REQUIRED; The EDIFACT acknowledgement settings.
	AcknowledgementSettings *EdifactAcknowledgementSettings

	// REQUIRED; The EDIFACT envelope settings.
	EnvelopeSettings *EdifactEnvelopeSettings

	// REQUIRED; The EDIFACT framing settings.
	FramingSettings *EdifactFramingSettings

	// REQUIRED; The EDIFACT message filter.
	MessageFilter *EdifactMessageFilter

	// REQUIRED; The EDIFACT processing Settings.
	ProcessingSettings *EdifactProcessingSettings

	// REQUIRED; The EDIFACT schema references.
	SchemaReferences []*EdifactSchemaReference

	// REQUIRED; The EDIFACT validation settings.
	ValidationSettings *EdifactValidationSettings

	// The EDIFACT delimiter override settings.
	EdifactDelimiterOverrides []*EdifactDelimiterOverride

	// The EDIFACT envelope override settings.
	EnvelopeOverrides []*EdifactEnvelopeOverride

	// The EDIFACT message filter list.
	MessageFilterList []*EdifactMessageIdentifier

	// The EDIFACT validation override settings.
	ValidationOverrides []*EdifactValidationOverride
}

// EdifactSchemaReference - The Edifact schema reference.
type EdifactSchemaReference struct {
	// REQUIRED; The message id.
	MessageID *string

	// REQUIRED; The message release version.
	MessageRelease *string

	// REQUIRED; The message version.
	MessageVersion *string

	// REQUIRED; The schema name.
	SchemaName *string

	// The association assigned code.
	AssociationAssignedCode *string

	// The sender application id.
	SenderApplicationID *string

	// The sender application qualifier.
	SenderApplicationQualifier *string
}

// EdifactValidationOverride - The Edifact validation override settings.
type EdifactValidationOverride struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The value indicating whether to validate character Set.
	EnforceCharacterSet *bool

	// REQUIRED; The message id on which the validation settings has to be applied.
	MessageID *string

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The value indicating whether to validate EDI types.
	ValidateEDITypes *bool

	// REQUIRED; The value indicating whether to validate XSD types.
	ValidateXSDTypes *bool
}

// EdifactValidationSettings - The Edifact agreement validation settings.
type EdifactValidationSettings struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool

	// REQUIRED; The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool

	// REQUIRED; The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool

	// REQUIRED; The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool

	// REQUIRED; The value indicating whether to Whether to validate EDI types.
	ValidateEDITypes *bool

	// REQUIRED; The value indicating whether to Whether to validate XSD types.
	ValidateXSDTypes *bool
}

// ErrorInfo - The error info.
type ErrorInfo struct {
	// REQUIRED; The error code.
	Code *string
}

// ErrorProperties - Error properties indicate why the Logic service was not able to process the incoming request. The reason
// is provided in the error message.
type ErrorProperties struct {
	// Error code.
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// ErrorResponse - Error response indicates Logic service is not able to process the incoming request. The error property
// contains the error details.
type ErrorResponse struct {
	// The error properties.
	Error *ErrorProperties
}

// Expression - The expression.
type Expression struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo

	// The sub expressions.
	Subexpressions []*Expression

	// The text.
	Text *string

	// Anything
	Value any
}

// ExpressionRoot - The expression root.
type ExpressionRoot struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo

	// The path.
	Path *string

	// The sub expressions.
	Subexpressions []*Expression

	// The text.
	Text *string

	// Anything
	Value any
}

// ExpressionTraces - The expression traces.
type ExpressionTraces struct {
	Inputs []*ExpressionRoot
}

// ExtendedErrorInfo - The extended error info.
type ExtendedErrorInfo struct {
	// REQUIRED; The error code.
	Code *ErrorResponseCode

	// REQUIRED; The error message.
	Message *string

	// The error message details.
	Details []*ExtendedErrorInfo

	// The inner error.
	InnerError any
}

// FlowAccessControlConfiguration - The access control configuration.
type FlowAccessControlConfiguration struct {
	// The access control configuration for workflow actions.
	Actions *FlowAccessControlConfigurationPolicy

	// The access control configuration for accessing workflow run contents.
	Contents *FlowAccessControlConfigurationPolicy

	// The access control configuration for invoking workflow triggers.
	Triggers *FlowAccessControlConfigurationPolicy

	// The access control configuration for workflow management.
	WorkflowManagement *FlowAccessControlConfigurationPolicy
}

// FlowAccessControlConfigurationPolicy - The access control configuration policy.
type FlowAccessControlConfigurationPolicy struct {
	// The allowed caller IP address ranges.
	AllowedCallerIPAddresses []*IPAddressRange

	// The authentication policies for workflow.
	OpenAuthenticationPolicies *OpenAuthenticationAccessPolicies
}

// FlowEndpoints - The flow endpoints configuration.
type FlowEndpoints struct {
	// The access endpoint ip address.
	AccessEndpointIPAddresses []*IPAddress

	// The outgoing ip address.
	OutgoingIPAddresses []*IPAddress
}

// FlowEndpointsConfiguration - The endpoints configuration.
type FlowEndpointsConfiguration struct {
	// The connector endpoints.
	Connector *FlowEndpoints

	// The workflow endpoints.
	Workflow *FlowEndpoints
}

// GenerateUpgradedDefinitionParameters - The parameters to generate upgraded definition.
type GenerateUpgradedDefinitionParameters struct {
	// The target schema version.
	TargetSchemaVersion *string
}

// GetCallbackURLParameters - The callback url parameters.
type GetCallbackURLParameters struct {
	// The key type.
	KeyType *KeyType

	// The expiry time.
	NotAfter *time.Time
}

// IPAddress - The ip address.
type IPAddress struct {
	// The address.
	Address *string
}

// IPAddressRange - The ip address range.
type IPAddressRange struct {
	// The IP address range.
	AddressRange *string
}

// IntegrationAccount - The integration account.
type IntegrationAccount struct {
	// The resource location.
	Location *string

	// The integration account properties.
	Properties *IntegrationAccountProperties

	// The sku.
	SKU *IntegrationAccountSKU

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationAccountAgreement - The integration account agreement.
type IntegrationAccountAgreement struct {
	// REQUIRED; The integration account agreement properties.
	Properties *IntegrationAccountAgreementProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationAccountAgreementFilter - The integration account agreement filter for odata query.
type IntegrationAccountAgreementFilter struct {
	// REQUIRED; The agreement type of integration account agreement.
	AgreementType *AgreementType
}

// IntegrationAccountAgreementListResult - The list of integration account agreements.
type IntegrationAccountAgreementListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration account agreements.
	Value []*IntegrationAccountAgreement
}

// IntegrationAccountAgreementProperties - The integration account agreement properties.
type IntegrationAccountAgreementProperties struct {
	// REQUIRED; The agreement type.
	AgreementType *AgreementType

	// REQUIRED; The agreement content.
	Content *AgreementContent

	// REQUIRED; The business identity of the guest partner.
	GuestIdentity *BusinessIdentity

	// REQUIRED; The integration account partner that is set as guest partner for this agreement.
	GuestPartner *string

	// REQUIRED; The business identity of the host partner.
	HostIdentity *BusinessIdentity

	// REQUIRED; The integration account partner that is set as host partner for this agreement.
	HostPartner *string

	// The metadata.
	Metadata any

	// READ-ONLY; The changed time.
	ChangedTime *time.Time

	// READ-ONLY; The created time.
	CreatedTime *time.Time
}

// IntegrationAccountCertificate - The integration account certificate.
type IntegrationAccountCertificate struct {
	// REQUIRED; The integration account certificate properties.
	Properties *IntegrationAccountCertificateProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationAccountCertificateListResult - The list of integration account certificates.
type IntegrationAccountCertificateListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration account certificates.
	Value []*IntegrationAccountCertificate
}

// IntegrationAccountCertificateProperties - The integration account certificate properties.
type IntegrationAccountCertificateProperties struct {
	// The key details in the key vault.
	Key *KeyVaultKeyReference

	// The metadata.
	Metadata any

	// The public certificate.
	PublicCertificate *string

	// READ-ONLY; The changed time.
	ChangedTime *time.Time

	// READ-ONLY; The created time.
	CreatedTime *time.Time
}

// IntegrationAccountListResult - The list of integration accounts.
type IntegrationAccountListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration accounts.
	Value []*IntegrationAccount
}

// IntegrationAccountMap - The integration account map.
type IntegrationAccountMap struct {
	// REQUIRED; The integration account map properties.
	Properties *IntegrationAccountMapProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationAccountMapFilter - The integration account map filter for odata query.
type IntegrationAccountMapFilter struct {
	// REQUIRED; The map type of integration account map.
	MapType *MapType
}

// IntegrationAccountMapListResult - The list of integration account maps.
type IntegrationAccountMapListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration account maps.
	Value []*IntegrationAccountMap
}

// IntegrationAccountMapProperties - The integration account map.
type IntegrationAccountMapProperties struct {
	// REQUIRED; The map type.
	MapType *MapType

	// The content.
	Content *string

	// The content type.
	ContentType *string

	// The metadata.
	Metadata any

	// The parameters schema of integration account map.
	ParametersSchema *IntegrationAccountMapPropertiesParametersSchema

	// READ-ONLY; The changed time.
	ChangedTime *time.Time

	// READ-ONLY; The content link.
	ContentLink *ContentLink

	// READ-ONLY; The created time.
	CreatedTime *time.Time
}

// IntegrationAccountMapPropertiesParametersSchema - The parameters schema of integration account map.
type IntegrationAccountMapPropertiesParametersSchema struct {
	// The reference name.
	Ref *string
}

// IntegrationAccountPartner - The integration account partner.
type IntegrationAccountPartner struct {
	// REQUIRED; The integration account partner properties.
	Properties *IntegrationAccountPartnerProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationAccountPartnerFilter - The integration account partner filter for odata query.
type IntegrationAccountPartnerFilter struct {
	// REQUIRED; The partner type of integration account partner.
	PartnerType *PartnerType
}

// IntegrationAccountPartnerListResult - The list of integration account partners.
type IntegrationAccountPartnerListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration account partners.
	Value []*IntegrationAccountPartner
}

// IntegrationAccountPartnerProperties - The integration account partner properties.
type IntegrationAccountPartnerProperties struct {
	// REQUIRED; The partner content.
	Content *PartnerContent

	// REQUIRED; The partner type.
	PartnerType *PartnerType

	// The metadata.
	Metadata any

	// READ-ONLY; The changed time.
	ChangedTime *time.Time

	// READ-ONLY; The created time.
	CreatedTime *time.Time
}

// IntegrationAccountProperties - The integration account properties.
type IntegrationAccountProperties struct {
	// The integration service environment.
	IntegrationServiceEnvironment *ResourceReference

	// The workflow state.
	State *WorkflowState
}

// IntegrationAccountSKU - The integration account sku.
type IntegrationAccountSKU struct {
	// REQUIRED; The sku name.
	Name *IntegrationAccountSKUName
}

// IntegrationAccountSchema - The integration account schema.
type IntegrationAccountSchema struct {
	// REQUIRED; The integration account schema properties.
	Properties *IntegrationAccountSchemaProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationAccountSchemaFilter - The integration account schema filter for odata query.
type IntegrationAccountSchemaFilter struct {
	// REQUIRED; The schema type of integration account schema.
	SchemaType *SchemaType
}

// IntegrationAccountSchemaListResult - The list of integration account schemas.
type IntegrationAccountSchemaListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration account schemas.
	Value []*IntegrationAccountSchema
}

// IntegrationAccountSchemaProperties - The integration account schema properties.
type IntegrationAccountSchemaProperties struct {
	// REQUIRED; The schema type.
	SchemaType *SchemaType

	// The content.
	Content *string

	// The content type.
	ContentType *string

	// The document name.
	DocumentName *string

	// The file name.
	FileName *string

	// The metadata.
	Metadata any

	// The target namespace of the schema.
	TargetNamespace *string

	// READ-ONLY; The changed time.
	ChangedTime *time.Time

	// READ-ONLY; The content link.
	ContentLink *ContentLink

	// READ-ONLY; The created time.
	CreatedTime *time.Time
}

// IntegrationAccountSession - The integration account session.
type IntegrationAccountSession struct {
	// REQUIRED; The integration account session properties.
	Properties *IntegrationAccountSessionProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationAccountSessionFilter - The integration account session filter.
type IntegrationAccountSessionFilter struct {
	// REQUIRED; The changed time of integration account sessions.
	ChangedTime *time.Time
}

// IntegrationAccountSessionListResult - The list of integration account sessions.
type IntegrationAccountSessionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration account sessions.
	Value []*IntegrationAccountSession
}

// IntegrationAccountSessionProperties - The integration account session properties.
type IntegrationAccountSessionProperties struct {
	// The session content.
	Content any

	// READ-ONLY; The changed time.
	ChangedTime *time.Time

	// READ-ONLY; The created time.
	CreatedTime *time.Time
}

// IntegrationServiceEnvironmenEncryptionConfiguration - The encryption configuration for the integration service environment.
type IntegrationServiceEnvironmenEncryptionConfiguration struct {
	// The encryption key reference.
	EncryptionKeyReference *IntegrationServiceEnvironmenEncryptionKeyReference
}

// IntegrationServiceEnvironmenEncryptionKeyReference - The encryption key details for the integration service environment.
type IntegrationServiceEnvironmenEncryptionKeyReference struct {
	// Gets the key name in the Key Vault.
	KeyName *string

	// The key vault reference.
	KeyVault *ResourceReference

	// Gets the version of the key specified in the keyName property.
	KeyVersion *string
}

// IntegrationServiceEnvironment - The integration service environment.
type IntegrationServiceEnvironment struct {
	// Managed service identity properties.
	Identity *ManagedServiceIdentity

	// The resource location.
	Location *string

	// The integration service environment properties.
	Properties *IntegrationServiceEnvironmentProperties

	// The sku.
	SKU *IntegrationServiceEnvironmentSKU

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationServiceEnvironmentAccessEndpoint - The integration service environment access endpoint.
type IntegrationServiceEnvironmentAccessEndpoint struct {
	// The access endpoint type.
	Type *IntegrationServiceEnvironmentAccessEndpointType
}

// IntegrationServiceEnvironmentListResult - The list of integration service environments.
type IntegrationServiceEnvironmentListResult struct {
	// The URL to get the next set of results.
	NextLink *string
	Value    []*IntegrationServiceEnvironment
}

// IntegrationServiceEnvironmentManagedAPI - The integration service environment managed api.
type IntegrationServiceEnvironmentManagedAPI struct {
	// The resource location.
	Location *string

	// The integration service environment managed api properties.
	Properties *IntegrationServiceEnvironmentManagedAPIProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// IntegrationServiceEnvironmentManagedAPIDeploymentParameters - The integration service environment managed api deployment
// parameters.
type IntegrationServiceEnvironmentManagedAPIDeploymentParameters struct {
	// The integration service environment managed api content link for deployment.
	ContentLinkDefinition *ContentLink
}

// IntegrationServiceEnvironmentManagedAPIListResult - The list of integration service environment managed APIs.
type IntegrationServiceEnvironmentManagedAPIListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The integration service environment managed APIs.
	Value []*IntegrationServiceEnvironmentManagedAPI
}

// IntegrationServiceEnvironmentManagedAPIProperties - The integration service environment managed api properties.
type IntegrationServiceEnvironmentManagedAPIProperties struct {
	// The integration service environment managed api deployment parameters.
	DeploymentParameters *IntegrationServiceEnvironmentManagedAPIDeploymentParameters

	// The integration service environment reference.
	IntegrationServiceEnvironment *ResourceReference

	// READ-ONLY; The API definition.
	APIDefinitionURL *string

	// READ-ONLY; The api definitions.
	APIDefinitions *APIResourceDefinitions

	// READ-ONLY; The backend service.
	BackendService *APIResourceBackendService

	// READ-ONLY; The capabilities.
	Capabilities []*string

	// READ-ONLY; The category.
	Category *APITier

	// READ-ONLY; The connection parameters.
	ConnectionParameters map[string]any

	// READ-ONLY; The api general information.
	GeneralInformation *APIResourceGeneralInformation

	// READ-ONLY; The metadata.
	Metadata *APIResourceMetadata

	// READ-ONLY; The name
	Name *string

	// READ-ONLY; The policies for the API.
	Policies *APIResourcePolicies

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// READ-ONLY; The runtime urls.
	RuntimeUrls []*string
}

// IntegrationServiceEnvironmentNetworkDependency - The azure async operation resource.
type IntegrationServiceEnvironmentNetworkDependency struct {
	// The network dependency category type.
	Category *IntegrationServiceEnvironmentNetworkDependencyCategoryType

	// The display name.
	DisplayName *string

	// The endpoints.
	Endpoints []*IntegrationServiceEnvironmentNetworkEndpoint
}

// IntegrationServiceEnvironmentNetworkDependencyHealth - The integration service environment subnet network health.
type IntegrationServiceEnvironmentNetworkDependencyHealth struct {
	// The error if any occurred during the operation.
	Error *ExtendedErrorInfo

	// The network dependency health state.
	State *IntegrationServiceEnvironmentNetworkDependencyHealthState
}

// IntegrationServiceEnvironmentNetworkEndpoint - The network endpoint.
type IntegrationServiceEnvironmentNetworkEndpoint struct {
	// The accessibility state.
	Accessibility *IntegrationServiceEnvironmentNetworkEndPointAccessibilityState

	// The domain name.
	DomainName *string

	// The ports.
	Ports []*string
}

// IntegrationServiceEnvironmentProperties - The integration service environment properties.
type IntegrationServiceEnvironmentProperties struct {
	// The encryption configuration.
	EncryptionConfiguration *IntegrationServiceEnvironmenEncryptionConfiguration

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration

	// Gets the tracking id.
	IntegrationServiceEnvironmentID *string

	// The network configuration.
	NetworkConfiguration *NetworkConfiguration

	// The provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// The integration service environment state.
	State *WorkflowState
}

// IntegrationServiceEnvironmentSKU - The integration service environment sku.
type IntegrationServiceEnvironmentSKU struct {
	// The sku capacity.
	Capacity *int32

	// The sku name.
	Name *IntegrationServiceEnvironmentSKUName
}

// IntegrationServiceEnvironmentSKUCapacity - The integration service environment sku capacity.
type IntegrationServiceEnvironmentSKUCapacity struct {
	// The default capacity.
	Default *int32

	// The maximum capacity.
	Maximum *int32

	// The minimum capacity.
	Minimum *int32

	// The sku scale type.
	ScaleType *IntegrationServiceEnvironmentSKUScaleType
}

// IntegrationServiceEnvironmentSKUDefinition - The integration service environment sku definition.
type IntegrationServiceEnvironmentSKUDefinition struct {
	// The sku capacity.
	Capacity *IntegrationServiceEnvironmentSKUCapacity

	// The resource type.
	ResourceType *string

	// The sku.
	SKU *IntegrationServiceEnvironmentSKUDefinitionSKU
}

// IntegrationServiceEnvironmentSKUDefinitionSKU - The sku.
type IntegrationServiceEnvironmentSKUDefinitionSKU struct {
	// The sku name.
	Name *IntegrationServiceEnvironmentSKUName

	// The sku tier.
	Tier *string
}

// IntegrationServiceEnvironmentSKUList - The list of integration service environment skus.
type IntegrationServiceEnvironmentSKUList struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of integration service environment skus.
	Value []*IntegrationServiceEnvironmentSKUDefinition
}

// IntegrationServiceEnvironmentSubnetNetworkHealth - The integration service environment subnet network health.
type IntegrationServiceEnvironmentSubnetNetworkHealth struct {
	// REQUIRED; The integration service environment network health state.
	NetworkDependencyHealthState *IntegrationServiceEnvironmentNetworkEndPointAccessibilityState

	// The outbound network dependencies.
	OutboundNetworkDependencies []*IntegrationServiceEnvironmentNetworkDependency

	// The integration service environment network health.
	OutboundNetworkHealth *IntegrationServiceEnvironmentNetworkDependencyHealth
}

// JSONSchema - The JSON schema.
type JSONSchema struct {
	// The JSON content.
	Content *string

	// The JSON title.
	Title *string
}

// KeyVaultKey - The key vault key.
type KeyVaultKey struct {
	// The key attributes.
	Attributes *KeyVaultKeyAttributes

	// The key id.
	Kid *string
}

// KeyVaultKeyAttributes - The key attributes.
type KeyVaultKeyAttributes struct {
	// When the key was created.
	Created *int64

	// Whether the key is enabled or not.
	Enabled *bool

	// When the key was updated.
	Updated *int64
}

// KeyVaultKeyCollection - Collection of key vault keys.
type KeyVaultKeyCollection struct {
	// The skip token.
	SkipToken *string

	// The key vault keys.
	Value []*KeyVaultKey
}

// KeyVaultKeyReference - The reference to the key vault key.
type KeyVaultKeyReference struct {
	// REQUIRED; The private key name in key vault.
	KeyName *string

	// REQUIRED; The key vault reference.
	KeyVault *KeyVaultKeyReferenceKeyVault

	// The private key version in key vault.
	KeyVersion *string
}

// KeyVaultKeyReferenceKeyVault - The key vault reference.
type KeyVaultKeyReferenceKeyVault struct {
	// The resource id.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// KeyVaultReference - The key vault reference.
type KeyVaultReference struct {
	// The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// ListKeyVaultKeysDefinition - The list key vault keys definition.
type ListKeyVaultKeysDefinition struct {
	// REQUIRED; The key vault reference.
	KeyVault *KeyVaultReference

	// The skip token.
	SkipToken *string
}

// ManagedAPI - The managed api definition.
type ManagedAPI struct {
	// The resource location.
	Location *string

	// The api resource properties.
	Properties *APIResourceProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// ManagedAPIListResult - The list of managed APIs.
type ManagedAPIListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The managed APIs.
	Value []*ManagedAPI
}

// ManagedServiceIdentity - Managed service identity properties.
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity. The type 'SystemAssigned' includes an implicitly created identity. The type
	// 'None' will remove any identities from the resource.
	Type *ManagedServiceIdentityType

	// The list of user assigned identities associated with the resource. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; Principal Id of managed service identity.
	PrincipalID *string

	// READ-ONLY; Tenant of managed service identity.
	TenantID *string
}

// NetworkConfiguration - The network configuration.
type NetworkConfiguration struct {
	// The access endpoint.
	AccessEndpoint *IntegrationServiceEnvironmentAccessEndpoint

	// The subnets.
	Subnets []*ResourceReference

	// Gets the virtual network address space.
	VirtualNetworkAddressSpace *string
}

// OpenAuthenticationAccessPolicies - AuthenticationPolicy of type Open.
type OpenAuthenticationAccessPolicies struct {
	// Open authentication policies.
	Policies map[string]*OpenAuthenticationAccessPolicy
}

// OpenAuthenticationAccessPolicy - Open authentication access policy defined by user.
type OpenAuthenticationAccessPolicy struct {
	// The access policy claims.
	Claims []*OpenAuthenticationPolicyClaim

	// Type of provider for OAuth.
	Type *OpenAuthenticationProviderType
}

// OpenAuthenticationPolicyClaim - Open authentication policy claim.
type OpenAuthenticationPolicyClaim struct {
	// The name of the claim.
	Name *string

	// The value of the claim.
	Value *string
}

// Operation - Logic REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// Operation: origin
	Origin *string

	// The properties.
	Properties any
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation: description.
	Description *string

	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.Logic
	Provider *string

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string
}

// OperationListResult - Result of the request to list Logic operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Logic operations supported by the Logic resource provider.
	Value []*Operation
}

// OperationResult - The operation result definition.
type OperationResult struct {
	// The workflow scope repetition code.
	Code *string

	// The correlation properties.
	Correlation *RunActionCorrelation

	// The end time of the workflow scope repetition.
	EndTime *time.Time

	// Anything
	Error          any
	IterationCount *int32

	// Gets the retry histories.
	RetryHistory []*RetryHistory

	// The start time of the workflow scope repetition.
	StartTime *time.Time

	// The status of the workflow scope repetition.
	Status *WorkflowStatus

	// READ-ONLY; Gets the inputs.
	Inputs any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the outputs.
	Outputs any

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// OperationResultProperties - The run operation result properties.
type OperationResultProperties struct {
	// The workflow scope repetition code.
	Code *string

	// The correlation properties.
	Correlation *RunActionCorrelation

	// The end time of the workflow scope repetition.
	EndTime *time.Time

	// Anything
	Error any

	// The start time of the workflow scope repetition.
	StartTime *time.Time

	// The status of the workflow scope repetition.
	Status *WorkflowStatus
}

// PartnerContent - The integration account partner content.
type PartnerContent struct {
	// The B2B partner content.
	B2B *B2BPartnerContent
}

// RecurrenceSchedule - The recurrence schedule.
type RecurrenceSchedule struct {
	// The hours.
	Hours []*int32

	// The minutes.
	Minutes []*int32

	// The month days.
	MonthDays []*int32

	// The monthly occurrences.
	MonthlyOccurrences []*RecurrenceScheduleOccurrence

	// The days of the week.
	WeekDays []*DaysOfWeek
}

// RecurrenceScheduleOccurrence - The recurrence schedule occurrence.
type RecurrenceScheduleOccurrence struct {
	// The day of the week.
	Day *DayOfWeek

	// The occurrence.
	Occurrence *int32
}

// RegenerateActionParameter - The access key regenerate action content.
type RegenerateActionParameter struct {
	// The key type.
	KeyType *KeyType
}

// RepetitionIndex - The workflow run action repetition index.
type RepetitionIndex struct {
	// REQUIRED; The index.
	ItemIndex *int32

	// The scope.
	ScopeName *string
}

// Request - A request.
type Request struct {
	// A list of all the headers attached to the request.
	Headers any

	// The HTTP method used for the request.
	Method *string

	// The destination for the request.
	URI *string
}

// RequestHistory - The request history.
type RequestHistory struct {
	// The resource location.
	Location *string

	// The request history properties.
	Properties *RequestHistoryProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// RequestHistoryListResult - The list of workflow request histories.
type RequestHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow request histories.
	Value []*RequestHistory
}

// RequestHistoryProperties - The request history.
type RequestHistoryProperties struct {
	// The time the request ended.
	EndTime *time.Time

	// The request.
	Request *Request

	// The response.
	Response *Response

	// The time the request started.
	StartTime *time.Time
}

// Resource - The base resource type.
type Resource struct {
	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// ResourceReference - The resource reference.
type ResourceReference struct {
	// The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// Response - A response.
type Response struct {
	// Details on the location of the body content.
	BodyLink *ContentLink

	// A list of all the headers attached to the response.
	Headers any

	// The status code of the response.
	StatusCode *int32
}

// RetryHistory - The retry history.
type RetryHistory struct {
	// Gets the client request Id.
	ClientRequestID *string

	// Gets the status code.
	Code *string

	// Gets the end time.
	EndTime *time.Time

	// Gets the error response.
	Error *ErrorResponse

	// Gets the service request Id.
	ServiceRequestID *string

	// Gets the start time.
	StartTime *time.Time
}

// RunActionCorrelation - The workflow run action correlation properties.
type RunActionCorrelation struct {
	// The action tracking identifier.
	ActionTrackingID *string

	// The client keywords.
	ClientKeywords []*string

	// The client tracking identifier.
	ClientTrackingID *string
}

// RunCorrelation - The correlation properties.
type RunCorrelation struct {
	// The client keywords.
	ClientKeywords []*string

	// The client tracking identifier.
	ClientTrackingID *string
}

// SKU - The sku type.
type SKU struct {
	// REQUIRED; The name.
	Name *SKUName

	// The reference to plan.
	Plan *ResourceReference
}

// SetTriggerStateActionDefinition - The set trigger state action definition.
type SetTriggerStateActionDefinition struct {
	// REQUIRED; The source.
	Source *WorkflowTriggerReference
}

// SubResource - The sub resource type.
type SubResource struct {
	// READ-ONLY; The resource id.
	ID *string
}

// SwaggerCustomDynamicList - The swagger custom dynamic list.
type SwaggerCustomDynamicList struct {
	// The built in operation.
	BuiltInOperation *string

	// The path to an item property which defines the display name of the item.
	ItemTitlePath *string

	// The path to a property which defines the value which should be used.
	ItemValuePath *string

	// The path to a response property (relative to the response object, not the response body) which contains an array of dynamic
	// value items.
	ItemsPath *string

	// The operation id to fetch dynamic schema.
	OperationID *string

	// The parameters.
	Parameters map[string]*SwaggerCustomDynamicProperties
}

// SwaggerCustomDynamicProperties - The swagger custom dynamic properties.
type SwaggerCustomDynamicProperties struct {
	// The operation id to fetch dynamic schema.
	OperationID *string

	// The operation parameters.
	Parameters map[string]*SwaggerCustomDynamicProperties

	// Json pointer to the dynamic schema on the response body.
	ValuePath *string
}

// SwaggerCustomDynamicSchema - The swagger custom dynamic schema.
type SwaggerCustomDynamicSchema struct {
	// The operation id to fetch dynamic schema.
	OperationID *string

	// The operation parameters.
	Parameters map[string]any

	// Json pointer to the dynamic schema on the response body.
	ValuePath *string
}

// SwaggerCustomDynamicTree - The swagger custom dynamic tree.
type SwaggerCustomDynamicTree struct {
	// The tree on-browse configuration
	Browse *SwaggerCustomDynamicTreeCommand

	// The tree on-open configuration
	Open *SwaggerCustomDynamicTreeCommand

	// The tree settings
	Settings *SwaggerCustomDynamicTreeSettings
}

// SwaggerCustomDynamicTreeCommand - The swagger tree command.
type SwaggerCustomDynamicTreeCommand struct {
	// The path to an item property which defines the display name of the item.
	ItemFullTitlePath *string

	// The path to an item property which defines the display name of the item.
	ItemIsParent *string

	// The path to an item property which defines the display name of the item.
	ItemTitlePath *string

	// The path to an item property which defines the display name of the item.
	ItemValuePath *string

	// The path to an item property which defines the display name of the item.
	ItemsPath *string

	// The path to an item property which defines the display name of the item.
	OperationID *string

	// Dictionary of
	Parameters map[string]*SwaggerCustomDynamicTreeParameter

	// The path to an item property which defines the display name of the item.
	SelectableFilter *string
}

// SwaggerCustomDynamicTreeParameter - The swagger custom dynamic tree parameter.
type SwaggerCustomDynamicTreeParameter struct {
	// The parameter reference.
	ParameterReference *string

	// Indicates whether the parameter is required.
	Required *bool

	// Gets or sets a path to a property in the currently selected item to pass as a value to a parameter for the given operation.
	SelectedItemValuePath *string

	// The parameter value.
	Value any
}

// SwaggerCustomDynamicTreeSettings - The swagger custom dynamic tree settings.
type SwaggerCustomDynamicTreeSettings struct {
	// Indicates whether leaf nodes can be selected.
	CanSelectLeafNodes *bool

	// Indicates whether parent nodes can be selected.
	CanSelectParentNodes *bool
}

// SwaggerExternalDocumentation - The swagger external documentation
type SwaggerExternalDocumentation struct {
	// The document description.
	Description *string

	// The vendor extensions.
	Extensions map[string]any

	// The documentation Uri.
	URI *string
}

// SwaggerSchema - The swagger schema.
type SwaggerSchema struct {
	// The additional properties.
	AdditionalProperties any

	// The schemas which must pass validation when this schema is used.
	AllOf []*SwaggerSchema

	// The discriminator.
	Discriminator *string

	// The dynamic list.
	DynamicListNew *SwaggerCustomDynamicList

	// The dynamic schema configuration.
	DynamicSchemaNew *SwaggerCustomDynamicProperties

	// The dynamic schema configuration.
	DynamicSchemaOld *SwaggerCustomDynamicSchema

	// The dynamic values tree configuration.
	DynamicTree *SwaggerCustomDynamicTree

	// The example value.
	Example any

	// The external documentation.
	ExternalDocs *SwaggerExternalDocumentation

	// The items schema.
	Items *SwaggerSchema

	// The maximum number of allowed properties.
	MaxProperties *int32

	// The minimum number of allowed properties.
	MinProperties *int32

	// Indicates the notification url extension. If this is set, the property's value should be a callback url for a webhook.
	NotificationURLExtension *bool

	// The object properties
	Properties map[string]*SwaggerSchema

	// Indicates whether this property must be present in the a request.
	ReadOnly *bool

	// The reference.
	Ref *string

	// The object required properties.
	Required []*string

	// The title.
	Title *string

	// The type
	Type *SwaggerSchemaType

	// The xml representation format for a property.
	XML *SwaggerXML
}

// SwaggerXML - The Swagger XML.
type SwaggerXML struct {
	// Indicates whether the property should be an attribute instead of an element.
	Attribute *bool

	// The vendor extensions.
	Extensions map[string]any

	// The xml element or attribute name.
	Name *string

	// The xml namespace.
	Namespace *string

	// The name prefix.
	Prefix *string

	// Indicates whether the array elements are wrapped in a container element.
	Wrapped *bool
}

// TrackingEvent - The tracking event.
type TrackingEvent struct {
	// REQUIRED; The event level.
	EventLevel *EventLevel

	// REQUIRED; The event time.
	EventTime *time.Time

	// REQUIRED; The record type.
	RecordType *TrackingRecordType

	// The error.
	Error *TrackingEventErrorInfo

	// The record.
	Record any
}

// TrackingEventErrorInfo - The tracking event error info.
type TrackingEventErrorInfo struct {
	// The code.
	Code *string

	// The message.
	Message *string
}

// TrackingEventsDefinition - The tracking events definition.
type TrackingEventsDefinition struct {
	// REQUIRED; The events.
	Events []*TrackingEvent

	// REQUIRED; The source type.
	SourceType *string

	// The track events options.
	TrackEventsOptions *TrackEventsOperationOptions
}

// UserAssignedIdentity - User Assigned identity properties.
type UserAssignedIdentity struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string
}

// Workflow - The workflow type.
type Workflow struct {
	// Managed service identity properties.
	Identity *ManagedServiceIdentity

	// The resource location.
	Location *string

	// The workflow properties.
	Properties *WorkflowProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowFilter - The workflow filter.
type WorkflowFilter struct {
	// The state of workflows.
	State *WorkflowState
}

// WorkflowListResult - The list of workflows.
type WorkflowListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of workflows.
	Value []*Workflow
}

// WorkflowOutputParameter - The workflow output parameter.
type WorkflowOutputParameter struct {
	// The description.
	Description *string

	// The metadata.
	Metadata any

	// The type.
	Type *ParameterType

	// The value.
	Value any

	// READ-ONLY; Gets the error.
	Error any
}

// WorkflowParameter - The workflow parameters.
type WorkflowParameter struct {
	// The description.
	Description *string

	// The metadata.
	Metadata any

	// The type.
	Type *ParameterType

	// The value.
	Value any
}

// WorkflowProperties - The workflow properties.
type WorkflowProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration

	// The definition.
	Definition any

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration

	// The integration account.
	IntegrationAccount *ResourceReference

	// The integration service environment.
	IntegrationServiceEnvironment *ResourceReference

	// The parameters.
	Parameters map[string]*WorkflowParameter

	// The state.
	State *WorkflowState

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// READ-ONLY; The sku.
	SKU *SKU

	// READ-ONLY; Gets the version.
	Version *string
}

// WorkflowReference - The workflow reference.
type WorkflowReference struct {
	// The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowRun - The workflow run.
type WorkflowRun struct {
	// The workflow run properties.
	Properties *WorkflowRunProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow run name.
	Name *string

	// READ-ONLY; Gets the workflow run type.
	Type *string
}

// WorkflowRunAction - The workflow run action.
type WorkflowRunAction struct {
	// The workflow run action properties.
	Properties *WorkflowRunActionProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow run action name.
	Name *string

	// READ-ONLY; Gets the workflow run action type.
	Type *string
}

// WorkflowRunActionFilter - The workflow run action filter.
type WorkflowRunActionFilter struct {
	// The status of workflow run action.
	Status *WorkflowStatus
}

// WorkflowRunActionListResult - The list of workflow run actions.
type WorkflowRunActionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow run actions.
	Value []*WorkflowRunAction
}

// WorkflowRunActionProperties - The workflow run action properties.
type WorkflowRunActionProperties struct {
	// The correlation properties.
	Correlation *RunActionCorrelation

	// Gets the retry histories.
	RetryHistory []*RetryHistory

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowRunActionRepetitionDefinition - The workflow run action repetition definition.
type WorkflowRunActionRepetitionDefinition struct {
	// REQUIRED; The workflow run action repetition properties definition.
	Properties *WorkflowRunActionRepetitionProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowRunActionRepetitionDefinitionCollection - A collection of workflow run action repetitions.
type WorkflowRunActionRepetitionDefinitionCollection struct {
	// The link used to get the next page of recommendations.
	NextLink *string
	Value    []*WorkflowRunActionRepetitionDefinition
}

// WorkflowRunActionRepetitionProperties - The workflow run action repetition properties definition.
type WorkflowRunActionRepetitionProperties struct {
	// The workflow scope repetition code.
	Code *string

	// The correlation properties.
	Correlation *RunActionCorrelation

	// The end time of the workflow scope repetition.
	EndTime *time.Time

	// Anything
	Error          any
	IterationCount *int32

	// The repetition indexes.
	RepetitionIndexes []*RepetitionIndex

	// Gets the retry histories.
	RetryHistory []*RetryHistory

	// The start time of the workflow scope repetition.
	StartTime *time.Time

	// The status of the workflow scope repetition.
	Status *WorkflowStatus

	// READ-ONLY; Gets the inputs.
	Inputs any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the outputs.
	Outputs any

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowRunFilter - The workflow run filter.
type WorkflowRunFilter struct {
	// The status of workflow run.
	Status *WorkflowStatus
}

// WorkflowRunListResult - The list of workflow runs.
type WorkflowRunListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow runs.
	Value []*WorkflowRun
}

// WorkflowRunProperties - The workflow run properties.
type WorkflowRunProperties struct {
	// The run correlation.
	Correlation *Correlation

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the correlation id.
	CorrelationID *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; Gets the outputs.
	Outputs map[string]*WorkflowOutputParameter

	// READ-ONLY; Gets the response of the flow run.
	Response *WorkflowRunTrigger

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the fired trigger.
	Trigger *WorkflowRunTrigger

	// READ-ONLY; Gets the wait end time.
	WaitEndTime *time.Time

	// READ-ONLY; Gets the reference to workflow version.
	Workflow *ResourceReference
}

// WorkflowRunTrigger - The workflow run trigger.
type WorkflowRunTrigger struct {
	// The run correlation.
	Correlation *Correlation

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; Gets the inputs.
	Inputs any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the name.
	Name *string

	// READ-ONLY; Gets the outputs.
	Outputs any

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the scheduled time.
	ScheduledTime *time.Time

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowTrigger - The workflow trigger.
type WorkflowTrigger struct {
	// The workflow trigger properties.
	Properties *WorkflowTriggerProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow trigger name.
	Name *string

	// READ-ONLY; Gets the workflow trigger type.
	Type *string
}

// WorkflowTriggerCallbackURL - The workflow trigger callback URL.
type WorkflowTriggerCallbackURL struct {
	// Gets the workflow trigger callback URL query parameters.
	Queries *WorkflowTriggerListCallbackURLQueries

	// Gets the workflow trigger callback URL relative path parameters.
	RelativePathParameters []*string

	// READ-ONLY; Gets the workflow trigger callback URL base path.
	BasePath *string

	// READ-ONLY; Gets the workflow trigger callback URL HTTP method.
	Method *string

	// READ-ONLY; Gets the workflow trigger callback URL relative path.
	RelativePath *string

	// READ-ONLY; Gets the workflow trigger callback URL.
	Value *string
}

// WorkflowTriggerFilter - The workflow trigger filter.
type WorkflowTriggerFilter struct {
	// The state of workflow trigger.
	State *WorkflowState
}

// WorkflowTriggerHistory - The workflow trigger history.
type WorkflowTriggerHistory struct {
	// Gets the workflow trigger history properties.
	Properties *WorkflowTriggerHistoryProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow trigger history name.
	Name *string

	// READ-ONLY; Gets the workflow trigger history type.
	Type *string
}

// WorkflowTriggerHistoryFilter - The workflow trigger history filter.
type WorkflowTriggerHistoryFilter struct {
	// The status of workflow trigger history.
	Status *WorkflowStatus
}

// WorkflowTriggerHistoryListResult - The list of workflow trigger histories.
type WorkflowTriggerHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow trigger histories.
	Value []*WorkflowTriggerHistory
}

// WorkflowTriggerHistoryProperties - The workflow trigger history properties.
type WorkflowTriggerHistoryProperties struct {
	// The run correlation.
	Correlation *Correlation

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; The value indicating whether trigger was fired.
	Fired *bool

	// READ-ONLY; Gets the link to input parameters.
	InputsLink *ContentLink

	// READ-ONLY; Gets the link to output parameters.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the reference to workflow run.
	Run *ResourceReference

	// READ-ONLY; The scheduled time.
	ScheduledTime *time.Time

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowTriggerListCallbackURLQueries - Gets the workflow trigger callback URL query parameters.
type WorkflowTriggerListCallbackURLQueries struct {
	// The api version.
	APIVersion *string

	// The SAS timestamp.
	Se *string

	// The SAS signature.
	Sig *string

	// The SAS permissions.
	Sp *string

	// The SAS version.
	Sv *string
}

// WorkflowTriggerListResult - The list of workflow triggers.
type WorkflowTriggerListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow triggers.
	Value []*WorkflowTrigger
}

// WorkflowTriggerProperties - The workflow trigger properties.
type WorkflowTriggerProperties struct {
	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time

	// READ-ONLY; Gets the last execution time.
	LastExecutionTime *time.Time

	// READ-ONLY; Gets the next execution time.
	NextExecutionTime *time.Time

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowTriggerProvisioningState

	// READ-ONLY; Gets the workflow trigger recurrence.
	Recurrence *WorkflowTriggerRecurrence

	// READ-ONLY; Gets the state.
	State *WorkflowState

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the reference to workflow.
	Workflow *ResourceReference
}

// WorkflowTriggerRecurrence - The workflow trigger recurrence.
type WorkflowTriggerRecurrence struct {
	// The end time.
	EndTime *string

	// The frequency.
	Frequency *RecurrenceFrequency

	// The interval.
	Interval *int32

	// The recurrence schedule.
	Schedule *RecurrenceSchedule

	// The start time.
	StartTime *string

	// The time zone.
	TimeZone *string
}

// WorkflowTriggerReference - The workflow trigger reference.
type WorkflowTriggerReference struct {
	// The workflow name.
	FlowName *string

	// The resource id.
	ID *string

	// The workflow trigger name.
	TriggerName *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowVersion - The workflow version.
type WorkflowVersion struct {
	// The resource location.
	Location *string

	// The workflow version properties.
	Properties *WorkflowVersionProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowVersionListResult - The list of workflow versions.
type WorkflowVersionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow versions.
	Value []*WorkflowVersion
}

// WorkflowVersionProperties - The workflow version properties.
type WorkflowVersionProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration

	// The definition.
	Definition any

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration

	// The integration account.
	IntegrationAccount *ResourceReference

	// The parameters.
	Parameters map[string]*WorkflowParameter

	// The state.
	State *WorkflowState

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// READ-ONLY; The sku.
	SKU *SKU

	// READ-ONLY; Gets the version.
	Version *string
}

// WsdlService - The WSDL service.
type WsdlService struct {
	// The list of endpoints' qualified names.
	EndpointQualifiedNames []*string

	// The qualified name.
	QualifiedName *string
}

// X12AcknowledgementSettings - The X12 agreement acknowledgement settings.
type X12AcknowledgementSettings struct {
	// REQUIRED; The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32

	// REQUIRED; The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32

	// REQUIRED; The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool

	// REQUIRED; The value indicating whether to batch implementation acknowledgements.
	BatchImplementationAcknowledgements *bool

	// REQUIRED; The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool

	// REQUIRED; The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool

	// REQUIRED; The value indicating whether implementation acknowledgement is needed.
	NeedImplementationAcknowledgement *bool

	// REQUIRED; The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool

	// REQUIRED; The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool

	// REQUIRED; The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool

	// REQUIRED; The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool

	// The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string

	// The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string

	// The functional acknowledgement version.
	FunctionalAcknowledgementVersion *string

	// The implementation acknowledgement version.
	ImplementationAcknowledgementVersion *string
}

// X12AgreementContent - The X12 agreement content.
type X12AgreementContent struct {
	// REQUIRED; The X12 one-way receive agreement.
	ReceiveAgreement *X12OneWayAgreement

	// REQUIRED; The X12 one-way send agreement.
	SendAgreement *X12OneWayAgreement
}

// X12DelimiterOverrides - The X12 delimiter override settings.
type X12DelimiterOverrides struct {
	// REQUIRED; The component separator.
	ComponentSeparator *int32

	// REQUIRED; The data element separator.
	DataElementSeparator *int32

	// REQUIRED; The replacement character.
	ReplaceCharacter *int32

	// REQUIRED; The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32

	// REQUIRED; The segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix

	// The message id.
	MessageID *string

	// The protocol version.
	ProtocolVersion *string

	// The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string
}

// X12EnvelopeOverride - The X12 envelope override settings.
type X12EnvelopeOverride struct {
	// REQUIRED; The date format.
	DateFormat *X12DateFormat

	// REQUIRED; The header version.
	HeaderVersion *string

	// REQUIRED; The message id on which this envelope settings has to be applied.
	MessageID *string

	// REQUIRED; The protocol version on which this envelope settings has to be applied.
	ProtocolVersion *string

	// REQUIRED; The receiver application id.
	ReceiverApplicationID *string

	// REQUIRED; The responsible agency code.
	ResponsibleAgencyCode *string

	// REQUIRED; The sender application id.
	SenderApplicationID *string

	// REQUIRED; The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string

	// REQUIRED; The time format.
	TimeFormat *X12TimeFormat

	// The functional identifier code.
	FunctionalIdentifierCode *string
}

// X12EnvelopeSettings - The X12 agreement envelope settings.
type X12EnvelopeSettings struct {
	// REQUIRED; The controls standards id.
	ControlStandardsID *int32

	// REQUIRED; The control version number.
	ControlVersionNumber *string

	// REQUIRED; The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool

	// REQUIRED; The group control number lower bound.
	GroupControlNumberLowerBound *int32

	// REQUIRED; The group control number upper bound.
	GroupControlNumberUpperBound *int32

	// REQUIRED; The group header agency code.
	GroupHeaderAgencyCode *string

	// REQUIRED; The group header date format.
	GroupHeaderDateFormat *X12DateFormat

	// REQUIRED; The group header time format.
	GroupHeaderTimeFormat *X12TimeFormat

	// REQUIRED; The group header version.
	GroupHeaderVersion *string

	// REQUIRED; The interchange control number lower bound.
	InterchangeControlNumberLowerBound *int32

	// REQUIRED; The interchange control number upper bound.
	InterchangeControlNumberUpperBound *int32

	// REQUIRED; The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool

	// REQUIRED; The receiver application id.
	ReceiverApplicationID *string

	// REQUIRED; The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool

	// REQUIRED; The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool

	// REQUIRED; The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool

	// REQUIRED; The sender application id.
	SenderApplicationID *string

	// REQUIRED; The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int32

	// REQUIRED; The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int32

	// REQUIRED; The usage indicator.
	UsageIndicator *UsageIndicator

	// REQUIRED; The value indicating whether to use control standards id as repetition character.
	UseControlStandardsIDAsRepetitionCharacter *bool

	// The functional group id.
	FunctionalGroupID *string

	// The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string

	// The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string
}

// X12FramingSettings - The X12 agreement framing settings.
type X12FramingSettings struct {
	// REQUIRED; The X12 character set.
	CharacterSet *X12CharacterSet

	// REQUIRED; The component separator.
	ComponentSeparator *int32

	// REQUIRED; The data element separator.
	DataElementSeparator *int32

	// REQUIRED; The replacement character.
	ReplaceCharacter *int32

	// REQUIRED; The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32

	// REQUIRED; The segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix
}

// X12MessageFilter - The X12 message filter for odata query.
type X12MessageFilter struct {
	// REQUIRED; The message filter type.
	MessageFilterType *MessageFilterType
}

// X12MessageIdentifier - The X12 message identifier.
type X12MessageIdentifier struct {
	// REQUIRED; The message id.
	MessageID *string
}

// X12OneWayAgreement - The X12 one-way agreement.
type X12OneWayAgreement struct {
	// REQUIRED; The X12 protocol settings.
	ProtocolSettings *X12ProtocolSettings

	// REQUIRED; The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity

	// REQUIRED; The sender business identity
	SenderBusinessIdentity *BusinessIdentity
}

// X12ProcessingSettings - The X12 processing settings.
type X12ProcessingSettings struct {
	// REQUIRED; The value indicating whether to convert numerical type to implied decimal.
	ConvertImpliedDecimal *bool

	// REQUIRED; The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool

	// REQUIRED; The value indicating whether to mask security information.
	MaskSecurityInfo *bool

	// REQUIRED; The value indicating whether to preserve interchange.
	PreserveInterchange *bool

	// REQUIRED; The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool

	// REQUIRED; The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool
}

// X12ProtocolSettings - The X12 agreement protocol settings.
type X12ProtocolSettings struct {
	// REQUIRED; The X12 acknowledgment settings.
	AcknowledgementSettings *X12AcknowledgementSettings

	// REQUIRED; The X12 envelope settings.
	EnvelopeSettings *X12EnvelopeSettings

	// REQUIRED; The X12 framing settings.
	FramingSettings *X12FramingSettings

	// REQUIRED; The X12 message filter.
	MessageFilter *X12MessageFilter

	// REQUIRED; The X12 processing settings.
	ProcessingSettings *X12ProcessingSettings

	// REQUIRED; The X12 schema references.
	SchemaReferences []*X12SchemaReference

	// REQUIRED; The X12 security settings.
	SecuritySettings *X12SecuritySettings

	// REQUIRED; The X12 validation settings.
	ValidationSettings *X12ValidationSettings

	// The X12 envelope override settings.
	EnvelopeOverrides []*X12EnvelopeOverride

	// The X12 message filter list.
	MessageFilterList []*X12MessageIdentifier

	// The X12 validation override settings.
	ValidationOverrides []*X12ValidationOverride

	// The X12 delimiter override settings.
	X12DelimiterOverrides []*X12DelimiterOverrides
}

// X12SchemaReference - The X12 schema reference.
type X12SchemaReference struct {
	// REQUIRED; The message id.
	MessageID *string

	// REQUIRED; The schema name.
	SchemaName *string

	// REQUIRED; The schema version.
	SchemaVersion *string

	// The sender application id.
	SenderApplicationID *string
}

// X12SecuritySettings - The X12 agreement security settings.
type X12SecuritySettings struct {
	// REQUIRED; The authorization qualifier.
	AuthorizationQualifier *string

	// REQUIRED; The security qualifier.
	SecurityQualifier *string

	// The authorization value.
	AuthorizationValue *string

	// The password value.
	PasswordValue *string
}

// X12ValidationOverride - The X12 validation override settings.
type X12ValidationOverride struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The message id on which the validation settings has to be applied.
	MessageID *string

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The value indicating whether to validate character Set.
	ValidateCharacterSet *bool

	// REQUIRED; The value indicating whether to validate EDI types.
	ValidateEDITypes *bool

	// REQUIRED; The value indicating whether to validate XSD types.
	ValidateXSDTypes *bool
}

// X12ValidationSettings - The X12 agreement validation settings.
type X12ValidationSettings struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool

	// REQUIRED; The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool

	// REQUIRED; The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool

	// REQUIRED; The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool

	// REQUIRED; The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool

	// REQUIRED; The value indicating whether to Whether to validate EDI types.
	ValidateEDITypes *bool

	// REQUIRED; The value indicating whether to Whether to validate XSD types.
	ValidateXSDTypes *bool
}
