//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotsecurity/armiotsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// SensorsServer is a fake server for instances of the armiotsecurity.SensorsClient type.
type SensorsServer struct {
	// CreateOrUpdate is the fake for method SensorsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, scope string, sensorName string, sensorModel armiotsecurity.SensorModel, options *armiotsecurity.SensorsClientCreateOrUpdateOptions) (resp azfake.Responder[armiotsecurity.SensorsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SensorsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, scope string, sensorName string, options *armiotsecurity.SensorsClientDeleteOptions) (resp azfake.Responder[armiotsecurity.SensorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DownloadActivation is the fake for method SensorsClient.DownloadActivation
	// HTTP status codes to indicate success: http.StatusOK
	DownloadActivation func(ctx context.Context, scope string, sensorName string, options *armiotsecurity.SensorsClientDownloadActivationOptions) (resp azfake.Responder[armiotsecurity.SensorsClientDownloadActivationResponse], errResp azfake.ErrorResponder)

	// DownloadResetPassword is the fake for method SensorsClient.DownloadResetPassword
	// HTTP status codes to indicate success: http.StatusOK
	DownloadResetPassword func(ctx context.Context, scope string, sensorName string, body armiotsecurity.ResetPasswordInput, options *armiotsecurity.SensorsClientDownloadResetPasswordOptions) (resp azfake.Responder[armiotsecurity.SensorsClientDownloadResetPasswordResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SensorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, sensorName string, options *armiotsecurity.SensorsClientGetOptions) (resp azfake.Responder[armiotsecurity.SensorsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SensorsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, scope string, options *armiotsecurity.SensorsClientListOptions) (resp azfake.Responder[armiotsecurity.SensorsClientListResponse], errResp azfake.ErrorResponder)

	// TriggerTiPackageUpdate is the fake for method SensorsClient.TriggerTiPackageUpdate
	// HTTP status codes to indicate success: http.StatusOK
	TriggerTiPackageUpdate func(ctx context.Context, scope string, sensorName string, options *armiotsecurity.SensorsClientTriggerTiPackageUpdateOptions) (resp azfake.Responder[armiotsecurity.SensorsClientTriggerTiPackageUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSensorsServerTransport creates a new instance of SensorsServerTransport with the provided implementation.
// The returned SensorsServerTransport instance is connected to an instance of armiotsecurity.SensorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSensorsServerTransport(srv *SensorsServer) *SensorsServerTransport {
	return &SensorsServerTransport{srv: srv}
}

// SensorsServerTransport connects instances of armiotsecurity.SensorsClient to instances of SensorsServer.
// Don't use this type directly, use NewSensorsServerTransport instead.
type SensorsServerTransport struct {
	srv *SensorsServer
}

// Do implements the policy.Transporter interface for SensorsServerTransport.
func (s *SensorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SensorsClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SensorsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SensorsClient.DownloadActivation":
		resp, err = s.dispatchDownloadActivation(req)
	case "SensorsClient.DownloadResetPassword":
		resp, err = s.dispatchDownloadResetPassword(req)
	case "SensorsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SensorsClient.List":
		resp, err = s.dispatchList(req)
	case "SensorsClient.TriggerTiPackageUpdate":
		resp, err = s.dispatchTriggerTiPackageUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SensorsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/sensors/(?P<sensorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiotsecurity.SensorModel](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	sensorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sensorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), scopeParam, sensorNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SensorModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SensorsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/sensors/(?P<sensorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	sensorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sensorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), scopeParam, sensorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SensorsServerTransport) dispatchDownloadActivation(req *http.Request) (*http.Response, error) {
	if s.srv.DownloadActivation == nil {
		return nil, &nonRetriableError{errors.New("fake for method DownloadActivation not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/sensors/(?P<sensorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/downloadActivation`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	sensorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sensorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DownloadActivation(req.Context(), scopeParam, sensorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SensorsServerTransport) dispatchDownloadResetPassword(req *http.Request) (*http.Response, error) {
	if s.srv.DownloadResetPassword == nil {
		return nil, &nonRetriableError{errors.New("fake for method DownloadResetPassword not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/sensors/(?P<sensorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/downloadResetPassword`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiotsecurity.ResetPasswordInput](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	sensorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sensorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DownloadResetPassword(req.Context(), scopeParam, sensorNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SensorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/sensors/(?P<sensorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	sensorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sensorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), scopeParam, sensorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SensorModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SensorsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/sensors`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.List(req.Context(), scopeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SensorsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SensorsServerTransport) dispatchTriggerTiPackageUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.TriggerTiPackageUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method TriggerTiPackageUpdate not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/sensors/(?P<sensorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggerTiPackageUpdate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	sensorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sensorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.TriggerTiPackageUpdate(req.Context(), scopeParam, sensorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
