//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/chaos/armchaos"
	"net/http"
	"net/url"
	"regexp"
)

// CapabilityTypesServer is a fake server for instances of the armchaos.CapabilityTypesClient type.
type CapabilityTypesServer struct {
	// Get is the fake for method CapabilityTypesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, locationName string, targetTypeName string, capabilityTypeName string, options *armchaos.CapabilityTypesClientGetOptions) (resp azfake.Responder[armchaos.CapabilityTypesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CapabilityTypesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(locationName string, targetTypeName string, options *armchaos.CapabilityTypesClientListOptions) (resp azfake.PagerResponder[armchaos.CapabilityTypesClientListResponse])
}

// NewCapabilityTypesServerTransport creates a new instance of CapabilityTypesServerTransport with the provided implementation.
// The returned CapabilityTypesServerTransport instance is connected to an instance of armchaos.CapabilityTypesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCapabilityTypesServerTransport(srv *CapabilityTypesServer) *CapabilityTypesServerTransport {
	return &CapabilityTypesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armchaos.CapabilityTypesClientListResponse]](),
	}
}

// CapabilityTypesServerTransport connects instances of armchaos.CapabilityTypesClient to instances of CapabilityTypesServer.
// Don't use this type directly, use NewCapabilityTypesServerTransport instead.
type CapabilityTypesServerTransport struct {
	srv          *CapabilityTypesServer
	newListPager *tracker[azfake.PagerResponder[armchaos.CapabilityTypesClientListResponse]]
}

// Do implements the policy.Transporter interface for CapabilityTypesServerTransport.
func (c *CapabilityTypesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CapabilityTypesClient.Get":
		resp, err = c.dispatchGet(req)
	case "CapabilityTypesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CapabilityTypesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/targetTypes/(?P<targetTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilityTypes/(?P<capabilityTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	targetTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("targetTypeName")])
	if err != nil {
		return nil, err
	}
	capabilityTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("capabilityTypeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), locationNameParam, targetTypeNameParam, capabilityTypeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CapabilityType, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapabilityTypesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/targetTypes/(?P<targetTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilityTypes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		targetTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("targetTypeName")])
		if err != nil {
			return nil, err
		}
		continuationTokenUnescaped, err := url.QueryUnescape(qp.Get("continuationToken"))
		if err != nil {
			return nil, err
		}
		continuationTokenParam := getOptional(continuationTokenUnescaped)
		var options *armchaos.CapabilityTypesClientListOptions
		if continuationTokenParam != nil {
			options = &armchaos.CapabilityTypesClientListOptions{
				ContinuationToken: continuationTokenParam,
			}
		}
		resp := c.srv.NewListPager(locationNameParam, targetTypeNameParam, options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armchaos.CapabilityTypesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
