//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListWebApps.json
func ExampleWebAppsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppCollection = armappservice.WebAppCollection{
		// 	Value: []*armappservice.Site{
		// 		{
		// 			Name: to.Ptr("sitef6141"),
		// 			Type: to.Ptr("Microsoft.Web/sites"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
		// 			Kind: to.Ptr("app"),
		// 			Location: to.Ptr("East US"),
		// 			Properties: &armappservice.SiteProperties{
		// 				AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
		// 				ClientAffinityEnabled: to.Ptr(true),
		// 				ClientCertEnabled: to.Ptr(false),
		// 				ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
		// 				ContainerSize: to.Ptr[int32](0),
		// 				CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
		// 				DailyMemoryTimeQuota: to.Ptr[int32](0),
		// 				DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
		// 				Enabled: to.Ptr(true),
		// 				EnabledHostNames: []*string{
		// 					to.Ptr("sitef6141.azurewebsites.net"),
		// 					to.Ptr("sitef6141.scm.azurewebsites.net")},
		// 					HostNameSSLStates: []*armappservice.HostNameSSLState{
		// 						{
		// 							Name: to.Ptr("sitef6141.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeStandard),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 						},
		// 						{
		// 							Name: to.Ptr("sitef6141.scm.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeRepository),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 					}},
		// 					HostNames: []*string{
		// 						to.Ptr("sitef6141.azurewebsites.net")},
		// 						HostNamesDisabled: to.Ptr(false),
		// 						HTTPSOnly: to.Ptr(false),
		// 						HyperV: to.Ptr(false),
		// 						IsXenon: to.Ptr(false),
		// 						KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
		// 						LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
		// 						OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
		// 						PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
		// 						RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
		// 						RepositorySiteName: to.Ptr("sitef6141"),
		// 						Reserved: to.Ptr(false),
		// 						ResourceConfig: &armappservice.ResourceConfig{
		// 							CPU: to.Ptr[float64](1),
		// 							Memory: to.Ptr("2.0Gi"),
		// 						},
		// 						ResourceGroup: to.Ptr("testrg123"),
		// 						ScmSiteAlsoStopped: to.Ptr(false),
		// 						ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		// 						SiteConfig: &armappservice.SiteConfig{
		// 							AcrUseManagedIdentityCreds: to.Ptr(false),
		// 							AlwaysOn: to.Ptr(false),
		// 							AppCommandLine: to.Ptr(""),
		// 							AutoHealEnabled: to.Ptr(false),
		// 							AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
		// 							},
		// 							DefaultDocuments: []*string{
		// 								to.Ptr("Default.htm"),
		// 								to.Ptr("Default.html"),
		// 								to.Ptr("Default.asp"),
		// 								to.Ptr("index.htm"),
		// 								to.Ptr("index.html"),
		// 								to.Ptr("iisstart.htm"),
		// 								to.Ptr("default.aspx"),
		// 								to.Ptr("index.php"),
		// 								to.Ptr("hostingstart.html")},
		// 								DetailedErrorLoggingEnabled: to.Ptr(false),
		// 								FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
		// 								FunctionAppScaleLimit: to.Ptr[int32](0),
		// 								FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
		// 								Http20Enabled: to.Ptr(false),
		// 								HTTPLoggingEnabled: to.Ptr(false),
		// 								LinuxFxVersion: to.Ptr(""),
		// 								LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
		// 								LogsDirectorySizeLimit: to.Ptr[int32](35),
		// 								ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
		// 								MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 								MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 								NetFrameworkVersion: to.Ptr("v4.0"),
		// 								NodeVersion: to.Ptr(""),
		// 								NumberOfWorkers: to.Ptr[int32](1),
		// 								PhpVersion: to.Ptr("5.6"),
		// 								PowerShellVersion: to.Ptr(""),
		// 								PythonVersion: to.Ptr(""),
		// 								RemoteDebuggingEnabled: to.Ptr(false),
		// 								RequestTracingEnabled: to.Ptr(false),
		// 								ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 								Use32BitWorkerProcess: to.Ptr(true),
		// 								VirtualApplications: []*armappservice.VirtualApplication{
		// 									{
		// 										PhysicalPath: to.Ptr("site\\wwwroot"),
		// 										PreloadEnabled: to.Ptr(false),
		// 										VirtualPath: to.Ptr("/"),
		// 								}},
		// 								VnetName: to.Ptr(""),
		// 								VnetPrivatePortsCount: to.Ptr[int32](0),
		// 								VnetRouteAllEnabled: to.Ptr(false),
		// 								WebSocketsEnabled: to.Ptr(false),
		// 							},
		// 							State: to.Ptr("Running"),
		// 							StorageAccountRequired: to.Ptr(false),
		// 							UsageState: to.Ptr(armappservice.UsageStateNormal),
		// 							VnetContentShareEnabled: to.Ptr(false),
		// 							VnetImagePullEnabled: to.Ptr(false),
		// 							VnetRouteAllEnabled: to.Ptr(false),
		// 							WorkloadProfileName: to.Ptr("myd4wp"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("sitef7252"),
		// 						Type: to.Ptr("Microsoft.Web/sites"),
		// 						ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef7252"),
		// 						Kind: to.Ptr("app"),
		// 						Location: to.Ptr("East US"),
		// 						Properties: &armappservice.SiteProperties{
		// 							AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
		// 							ClientAffinityEnabled: to.Ptr(true),
		// 							ClientCertEnabled: to.Ptr(false),
		// 							ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
		// 							ContainerSize: to.Ptr[int32](0),
		// 							CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
		// 							DailyMemoryTimeQuota: to.Ptr[int32](0),
		// 							DefaultHostName: to.Ptr("sitef7252.azurewebsites.net"),
		// 							Enabled: to.Ptr(true),
		// 							EnabledHostNames: []*string{
		// 								to.Ptr("sitef7252.azurewebsites.net"),
		// 								to.Ptr("sitef7252.scm.azurewebsites.net")},
		// 								HostNameSSLStates: []*armappservice.HostNameSSLState{
		// 									{
		// 										Name: to.Ptr("sitef7252.azurewebsites.net"),
		// 										HostType: to.Ptr(armappservice.HostTypeStandard),
		// 										SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 									},
		// 									{
		// 										Name: to.Ptr("sitef7252.scm.azurewebsites.net"),
		// 										HostType: to.Ptr(armappservice.HostTypeRepository),
		// 										SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 								}},
		// 								HostNames: []*string{
		// 									to.Ptr("sitef7252.azurewebsites.net")},
		// 									HostNamesDisabled: to.Ptr(false),
		// 									HTTPSOnly: to.Ptr(false),
		// 									HyperV: to.Ptr(false),
		// 									IsXenon: to.Ptr(false),
		// 									KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
		// 									LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
		// 									OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
		// 									PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
		// 									RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
		// 									RepositorySiteName: to.Ptr("sitef7252"),
		// 									Reserved: to.Ptr(false),
		// 									ResourceConfig: &armappservice.ResourceConfig{
		// 										CPU: to.Ptr[float64](1),
		// 										Memory: to.Ptr("2.0Gi"),
		// 									},
		// 									ResourceGroup: to.Ptr("testrg123"),
		// 									ScmSiteAlsoStopped: to.Ptr(false),
		// 									ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		// 									SiteConfig: &armappservice.SiteConfig{
		// 										AcrUseManagedIdentityCreds: to.Ptr(false),
		// 										AlwaysOn: to.Ptr(false),
		// 										AppCommandLine: to.Ptr(""),
		// 										AutoHealEnabled: to.Ptr(false),
		// 										AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
		// 										},
		// 										DefaultDocuments: []*string{
		// 											to.Ptr("Default.htm"),
		// 											to.Ptr("Default.html"),
		// 											to.Ptr("Default.asp"),
		// 											to.Ptr("index.htm"),
		// 											to.Ptr("index.html"),
		// 											to.Ptr("iisstart.htm"),
		// 											to.Ptr("default.aspx"),
		// 											to.Ptr("index.php"),
		// 											to.Ptr("hostingstart.html")},
		// 											DetailedErrorLoggingEnabled: to.Ptr(false),
		// 											FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
		// 											FunctionAppScaleLimit: to.Ptr[int32](0),
		// 											FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
		// 											Http20Enabled: to.Ptr(false),
		// 											HTTPLoggingEnabled: to.Ptr(false),
		// 											LinuxFxVersion: to.Ptr(""),
		// 											LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
		// 											LogsDirectorySizeLimit: to.Ptr[int32](35),
		// 											ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
		// 											MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 											MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 											NetFrameworkVersion: to.Ptr("v4.0"),
		// 											NodeVersion: to.Ptr(""),
		// 											NumberOfWorkers: to.Ptr[int32](1),
		// 											PhpVersion: to.Ptr("5.6"),
		// 											PowerShellVersion: to.Ptr(""),
		// 											PythonVersion: to.Ptr(""),
		// 											RemoteDebuggingEnabled: to.Ptr(false),
		// 											RequestTracingEnabled: to.Ptr(false),
		// 											ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 											Use32BitWorkerProcess: to.Ptr(true),
		// 											VirtualApplications: []*armappservice.VirtualApplication{
		// 												{
		// 													PhysicalPath: to.Ptr("site\\wwwroot"),
		// 													PreloadEnabled: to.Ptr(false),
		// 													VirtualPath: to.Ptr("/"),
		// 											}},
		// 											VnetName: to.Ptr(""),
		// 											VnetPrivatePortsCount: to.Ptr[int32](0),
		// 											VnetRouteAllEnabled: to.Ptr(false),
		// 											WebSocketsEnabled: to.Ptr(false),
		// 										},
		// 										State: to.Ptr("Running"),
		// 										StorageAccountRequired: to.Ptr(false),
		// 										UsageState: to.Ptr(armappservice.UsageStateNormal),
		// 										VnetContentShareEnabled: to.Ptr(false),
		// 										VnetImagePullEnabled: to.Ptr(false),
		// 										VnetRouteAllEnabled: to.Ptr(false),
		// 										WorkloadProfileName: to.Ptr("myd4wp"),
		// 									},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListWebAppsByResourceGroup.json
func ExampleWebAppsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListByResourceGroupPager("testrg123", &armappservice.WebAppsClientListByResourceGroupOptions{IncludeSlots: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppCollection = armappservice.WebAppCollection{
		// 	Value: []*armappservice.Site{
		// 		{
		// 			Name: to.Ptr("sitef6141"),
		// 			Type: to.Ptr("Microsoft.Web/sites"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
		// 			Kind: to.Ptr("app"),
		// 			Location: to.Ptr("East US"),
		// 			Properties: &armappservice.SiteProperties{
		// 				AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
		// 				ClientAffinityEnabled: to.Ptr(true),
		// 				ClientCertEnabled: to.Ptr(false),
		// 				ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
		// 				ContainerSize: to.Ptr[int32](0),
		// 				CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
		// 				DailyMemoryTimeQuota: to.Ptr[int32](0),
		// 				DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
		// 				Enabled: to.Ptr(true),
		// 				EnabledHostNames: []*string{
		// 					to.Ptr("sitef6141.azurewebsites.net"),
		// 					to.Ptr("sitef6141.scm.azurewebsites.net")},
		// 					HostNameSSLStates: []*armappservice.HostNameSSLState{
		// 						{
		// 							Name: to.Ptr("sitef6141.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeStandard),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 						},
		// 						{
		// 							Name: to.Ptr("sitef6141.scm.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeRepository),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 					}},
		// 					HostNames: []*string{
		// 						to.Ptr("sitef6141.azurewebsites.net")},
		// 						HostNamesDisabled: to.Ptr(false),
		// 						HTTPSOnly: to.Ptr(false),
		// 						HyperV: to.Ptr(false),
		// 						IsXenon: to.Ptr(false),
		// 						KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
		// 						LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
		// 						OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
		// 						PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
		// 						RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
		// 						RepositorySiteName: to.Ptr("sitef6141"),
		// 						Reserved: to.Ptr(false),
		// 						ResourceConfig: &armappservice.ResourceConfig{
		// 							CPU: to.Ptr[float64](1),
		// 							Memory: to.Ptr("2.0Gi"),
		// 						},
		// 						ResourceGroup: to.Ptr("testrg123"),
		// 						ScmSiteAlsoStopped: to.Ptr(false),
		// 						ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		// 						SiteConfig: &armappservice.SiteConfig{
		// 							AcrUseManagedIdentityCreds: to.Ptr(false),
		// 							AlwaysOn: to.Ptr(false),
		// 							AppCommandLine: to.Ptr(""),
		// 							AutoHealEnabled: to.Ptr(false),
		// 							AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
		// 							},
		// 							DefaultDocuments: []*string{
		// 								to.Ptr("Default.htm"),
		// 								to.Ptr("Default.html"),
		// 								to.Ptr("Default.asp"),
		// 								to.Ptr("index.htm"),
		// 								to.Ptr("index.html"),
		// 								to.Ptr("iisstart.htm"),
		// 								to.Ptr("default.aspx"),
		// 								to.Ptr("index.php"),
		// 								to.Ptr("hostingstart.html")},
		// 								DetailedErrorLoggingEnabled: to.Ptr(false),
		// 								FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
		// 								FunctionAppScaleLimit: to.Ptr[int32](0),
		// 								FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
		// 								Http20Enabled: to.Ptr(false),
		// 								HTTPLoggingEnabled: to.Ptr(false),
		// 								LinuxFxVersion: to.Ptr(""),
		// 								LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
		// 								LogsDirectorySizeLimit: to.Ptr[int32](35),
		// 								ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
		// 								MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 								MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 								NetFrameworkVersion: to.Ptr("v4.0"),
		// 								NodeVersion: to.Ptr(""),
		// 								NumberOfWorkers: to.Ptr[int32](1),
		// 								PhpVersion: to.Ptr("5.6"),
		// 								PowerShellVersion: to.Ptr(""),
		// 								PythonVersion: to.Ptr(""),
		// 								RemoteDebuggingEnabled: to.Ptr(false),
		// 								RequestTracingEnabled: to.Ptr(false),
		// 								ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 								Use32BitWorkerProcess: to.Ptr(true),
		// 								VirtualApplications: []*armappservice.VirtualApplication{
		// 									{
		// 										PhysicalPath: to.Ptr("site\\wwwroot"),
		// 										PreloadEnabled: to.Ptr(false),
		// 										VirtualPath: to.Ptr("/"),
		// 								}},
		// 								VnetName: to.Ptr(""),
		// 								VnetPrivatePortsCount: to.Ptr[int32](0),
		// 								VnetRouteAllEnabled: to.Ptr(false),
		// 								WebSocketsEnabled: to.Ptr(false),
		// 							},
		// 							State: to.Ptr("Running"),
		// 							StorageAccountRequired: to.Ptr(false),
		// 							UsageState: to.Ptr(armappservice.UsageStateNormal),
		// 							VnetContentShareEnabled: to.Ptr(false),
		// 							VnetImagePullEnabled: to.Ptr(false),
		// 							VnetRouteAllEnabled: to.Ptr(false),
		// 							WorkloadProfileName: to.Ptr("myd4wp"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("sitef7252"),
		// 						Type: to.Ptr("Microsoft.Web/sites"),
		// 						ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef7252"),
		// 						Kind: to.Ptr("app"),
		// 						Location: to.Ptr("East US"),
		// 						Properties: &armappservice.SiteProperties{
		// 							AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
		// 							ClientAffinityEnabled: to.Ptr(true),
		// 							ClientCertEnabled: to.Ptr(false),
		// 							ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
		// 							ContainerSize: to.Ptr[int32](0),
		// 							CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
		// 							DailyMemoryTimeQuota: to.Ptr[int32](0),
		// 							DefaultHostName: to.Ptr("sitef7252.azurewebsites.net"),
		// 							Enabled: to.Ptr(true),
		// 							EnabledHostNames: []*string{
		// 								to.Ptr("sitef7252.azurewebsites.net"),
		// 								to.Ptr("sitef7252.scm.azurewebsites.net")},
		// 								HostNameSSLStates: []*armappservice.HostNameSSLState{
		// 									{
		// 										Name: to.Ptr("sitef7252.azurewebsites.net"),
		// 										HostType: to.Ptr(armappservice.HostTypeStandard),
		// 										SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 									},
		// 									{
		// 										Name: to.Ptr("sitef7252.scm.azurewebsites.net"),
		// 										HostType: to.Ptr(armappservice.HostTypeRepository),
		// 										SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 								}},
		// 								HostNames: []*string{
		// 									to.Ptr("sitef7252.azurewebsites.net")},
		// 									HostNamesDisabled: to.Ptr(false),
		// 									HTTPSOnly: to.Ptr(false),
		// 									HyperV: to.Ptr(false),
		// 									IsXenon: to.Ptr(false),
		// 									KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
		// 									LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
		// 									OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
		// 									PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
		// 									RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
		// 									RepositorySiteName: to.Ptr("sitef7252"),
		// 									Reserved: to.Ptr(false),
		// 									ResourceConfig: &armappservice.ResourceConfig{
		// 										CPU: to.Ptr[float64](1),
		// 										Memory: to.Ptr("2.0Gi"),
		// 									},
		// 									ResourceGroup: to.Ptr("testrg123"),
		// 									ScmSiteAlsoStopped: to.Ptr(false),
		// 									ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		// 									SiteConfig: &armappservice.SiteConfig{
		// 										AcrUseManagedIdentityCreds: to.Ptr(false),
		// 										AlwaysOn: to.Ptr(false),
		// 										AppCommandLine: to.Ptr(""),
		// 										AutoHealEnabled: to.Ptr(false),
		// 										AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
		// 										},
		// 										DefaultDocuments: []*string{
		// 											to.Ptr("Default.htm"),
		// 											to.Ptr("Default.html"),
		// 											to.Ptr("Default.asp"),
		// 											to.Ptr("index.htm"),
		// 											to.Ptr("index.html"),
		// 											to.Ptr("iisstart.htm"),
		// 											to.Ptr("default.aspx"),
		// 											to.Ptr("index.php"),
		// 											to.Ptr("hostingstart.html")},
		// 											DetailedErrorLoggingEnabled: to.Ptr(false),
		// 											FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
		// 											FunctionAppScaleLimit: to.Ptr[int32](0),
		// 											FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
		// 											Http20Enabled: to.Ptr(false),
		// 											HTTPLoggingEnabled: to.Ptr(false),
		// 											LinuxFxVersion: to.Ptr(""),
		// 											LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
		// 											LogsDirectorySizeLimit: to.Ptr[int32](35),
		// 											ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
		// 											MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 											MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 											NetFrameworkVersion: to.Ptr("v4.0"),
		// 											NodeVersion: to.Ptr(""),
		// 											NumberOfWorkers: to.Ptr[int32](1),
		// 											PhpVersion: to.Ptr("5.6"),
		// 											PowerShellVersion: to.Ptr(""),
		// 											PythonVersion: to.Ptr(""),
		// 											RemoteDebuggingEnabled: to.Ptr(false),
		// 											RequestTracingEnabled: to.Ptr(false),
		// 											ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 											Use32BitWorkerProcess: to.Ptr(true),
		// 											VirtualApplications: []*armappservice.VirtualApplication{
		// 												{
		// 													PhysicalPath: to.Ptr("site\\wwwroot"),
		// 													PreloadEnabled: to.Ptr(false),
		// 													VirtualPath: to.Ptr("/"),
		// 											}},
		// 											VnetName: to.Ptr(""),
		// 											VnetPrivatePortsCount: to.Ptr[int32](0),
		// 											VnetRouteAllEnabled: to.Ptr(false),
		// 											WebSocketsEnabled: to.Ptr(false),
		// 										},
		// 										State: to.Ptr("Running"),
		// 										StorageAccountRequired: to.Ptr(false),
		// 										UsageState: to.Ptr(armappservice.UsageStateNormal),
		// 										VnetContentShareEnabled: to.Ptr(false),
		// 										VnetImagePullEnabled: to.Ptr(false),
		// 										VnetRouteAllEnabled: to.Ptr(false),
		// 										WorkloadProfileName: to.Ptr("myd4wp"),
		// 									},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebApp.json
func ExampleWebAppsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().Get(ctx, "testrg123", "sitef6141", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141.azurewebsites.net"),
	// 			to.Ptr("sitef6141.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceConfig: &armappservice.ResourceConfig{
	// 					CPU: to.Ptr[float64](1),
	// 					Memory: to.Ptr("2.0Gi"),
	// 				},
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 					WorkloadProfileName: to.Ptr("myd4wp"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/CloneWebApp.json
func ExampleWebAppsClient_BeginCreateOrUpdate_cloneWebApp() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginCreateOrUpdate(ctx, "testrg123", "sitef6141", armappservice.Site{
		Kind:     to.Ptr("app"),
		Location: to.Ptr("East US"),
		Properties: &armappservice.SiteProperties{
			CloningInfo: &armappservice.CloningInfo{
				AppSettingsOverrides: map[string]*string{
					"Setting1": to.Ptr("NewValue1"),
					"Setting3": to.Ptr("NewValue5"),
				},
				CloneCustomHostNames:   to.Ptr(true),
				CloneSourceControl:     to.Ptr(true),
				ConfigureLoadBalancing: to.Ptr(false),
				HostingEnvironment:     to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/hostingenvironments/aseforsites"),
				Overwrite:              to.Ptr(false),
				SourceWebAppID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/sites/srcsiteg478"),
				SourceWebAppLocation:   to.Ptr("West Europe"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141.azurewebsites.net"),
	// 			to.Ptr("sitef6141.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/CreateOrUpdateWebApp.json
func ExampleWebAppsClient_BeginCreateOrUpdate_createOrUpdateWebApp() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginCreateOrUpdate(ctx, "testrg123", "sitef6141", armappservice.Site{
		Kind:     to.Ptr("app"),
		Location: to.Ptr("East US"),
		Properties: &armappservice.SiteProperties{
			ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141.azurewebsites.net"),
	// 			to.Ptr("sitef6141.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceConfig: &armappservice.ResourceConfig{
	// 					CPU: to.Ptr[float64](1),
	// 					Memory: to.Ptr("2.0Gi"),
	// 				},
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 					WorkloadProfileName: to.Ptr("myd4wp"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/DeleteWebApp.json
func ExampleWebAppsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().Delete(ctx, "testrg123", "sitef6141", &armappservice.WebAppsClientDeleteOptions{DeleteMetrics: nil,
		DeleteEmptyServerFarm: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateWebApp.json
func ExampleWebAppsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().Update(ctx, "testrg123", "sitef6141", armappservice.SitePatchResource{
		Properties: &armappservice.SitePatchResourceProperties{
			ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141.azurewebsites.net"),
	// 			to.Ptr("sitef6141.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceConfig: &armappservice.ResourceConfig{
	// 					CPU: to.Ptr[float64](1),
	// 					Memory: to.Ptr("2.0Gi"),
	// 				},
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 					WorkloadProfileName: to.Ptr("myd4wp"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AnalyzeCustomHostName.json
func ExampleWebAppsClient_AnalyzeCustomHostname() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().AnalyzeCustomHostname(ctx, "testrg123", "sitef6141", &armappservice.WebAppsClientAnalyzeCustomHostnameOptions{HostName: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomHostnameAnalysisResult = armappservice.CustomHostnameAnalysisResult{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
	// 	Properties: &armappservice.CustomHostnameAnalysisResultProperties{
	// 		CNameRecords: []*string{
	// 			to.Ptr("siteog.azurewebsites.net")},
	// 			ConflictingAppResourceID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/siteog"),
	// 			CustomDomainVerificationFailureInfo: &armappservice.ErrorEntity{
	// 				Code: to.Ptr("07198"),
	// 				Message: to.Ptr("Custom domain verification failed on conflicting CNAMEs."),
	// 			},
	// 			CustomDomainVerificationTest: to.Ptr(armappservice.DNSVerificationTestResultPassed),
	// 			HasConflictAcrossSubscription: to.Ptr(true),
	// 			HasConflictOnScaleUnit: to.Ptr(false),
	// 			IsHostnameAlreadyVerified: to.Ptr(true),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ApplySlotConfig.json
func ExampleWebAppsClient_ApplySlotConfigToProduction() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().ApplySlotConfigToProduction(ctx, "testrg123", "sitef6141", armappservice.CsmSlotEntity{
		PreserveVnet: to.Ptr(true),
		TargetSlot:   to.Ptr("staging"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/BackupWebApp.json
func ExampleWebAppsClient_Backup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().Backup(ctx, "testrg123", "sitef6141", armappservice.BackupRequest{
		Properties: &armappservice.BackupRequestProperties{
			BackupName: to.Ptr("abcdwe"),
			BackupSchedule: &armappservice.BackupSchedule{
				FrequencyInterval:     to.Ptr[int32](7),
				FrequencyUnit:         to.Ptr(armappservice.FrequencyUnitDay),
				KeepAtLeastOneBackup:  to.Ptr(true),
				RetentionPeriodInDays: to.Ptr[int32](30),
				StartTime:             to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T17:33:11.641Z"); return t }()),
			},
			Databases: []*armappservice.DatabaseBackupSetting{
				{
					Name:                 to.Ptr("backenddb"),
					ConnectionString:     to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
					ConnectionStringName: to.Ptr("backend"),
					DatabaseType:         to.Ptr(armappservice.DatabaseTypeSQLAzure),
				},
				{
					Name:                 to.Ptr("statsdb"),
					ConnectionString:     to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
					ConnectionStringName: to.Ptr("stats"),
					DatabaseType:         to.Ptr(armappservice.DatabaseTypeSQLAzure),
				}},
			Enabled:           to.Ptr(true),
			StorageAccountURL: to.Ptr("DefaultEndpointsProtocol=https;AccountName=storagesample;AccountKey=<account-key>"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BackupItem = armappservice.BackupItem{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141"),
	// 	Properties: &armappservice.BackupItemProperties{
	// 		Name: to.Ptr("sitef6141_2023-01-01"),
	// 		BlobName: to.Ptr("sitef6141_2023-01-01"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-03T17:33:11.641Z"); return t}()),
	// 		Databases: []*armappservice.DatabaseBackupSetting{
	// 			{
	// 				Name: to.Ptr("backenddb"),
	// 				ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
	// 				ConnectionStringName: to.Ptr("backend"),
	// 				DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
	// 			},
	// 			{
	// 				Name: to.Ptr("statsdb"),
	// 				ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
	// 				ConnectionStringName: to.Ptr("stats"),
	// 				DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
	// 		}},
	// 		FinishedTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T17:33:11.641Z"); return t}()),
	// 		BackupID: to.Ptr[int32](12345),
	// 		LastRestoreTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-04T17:33:11.641Z"); return t}()),
	// 		Log: to.Ptr("Succeeded"),
	// 		Scheduled: to.Ptr(true),
	// 		SizeInBytes: to.Ptr[int64](56091883),
	// 		Status: to.Ptr(armappservice.BackupItemStatusInProgress),
	// 		StorageAccountURL: to.Ptr("DefaultEndpointsProtocol=https;AccountName=storagesample;AccountKey=<account-key>"),
	// 		WebsiteSizeInBytes: to.Ptr[int64](56091883),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListWebAppBackups.json
func ExampleWebAppsClient_NewListBackupsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListBackupsPager("testrg123", "sitef6141", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.BackupItemCollection = armappservice.BackupItemCollection{
		// 	Value: []*armappservice.BackupItem{
		// 		{
		// 			Name: to.Ptr("sitef6141"),
		// 			Type: to.Ptr("Microsoft.Web/sites"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/backups/12345"),
		// 			Properties: &armappservice.BackupItemProperties{
		// 				Name: to.Ptr("sitef6141_2023-01-01"),
		// 				BlobName: to.Ptr("sitef6141_2023-01-01"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-03T17:33:11.641Z"); return t}()),
		// 				Databases: []*armappservice.DatabaseBackupSetting{
		// 					{
		// 						Name: to.Ptr("backenddb"),
		// 						ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
		// 						ConnectionStringName: to.Ptr("backend"),
		// 						DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
		// 					},
		// 					{
		// 						Name: to.Ptr("statsdb"),
		// 						ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
		// 						ConnectionStringName: to.Ptr("stats"),
		// 						DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
		// 				}},
		// 				FinishedTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-05T17:33:11.641Z"); return t}()),
		// 				BackupID: to.Ptr[int32](12345),
		// 				LastRestoreTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-04T17:33:11.641Z"); return t}()),
		// 				Log: to.Ptr("Succeeded"),
		// 				Scheduled: to.Ptr(true),
		// 				SizeInBytes: to.Ptr[int64](56091883),
		// 				Status: to.Ptr(armappservice.BackupItemStatusInProgress),
		// 				StorageAccountURL: to.Ptr("DefaultEndpointsProtocol=https;AccountName=storagesample;AccountKey=<account-key>"),
		// 				WebsiteSizeInBytes: to.Ptr[int64](56091883),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebAppBackup.json
func ExampleWebAppsClient_GetBackupStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetBackupStatus(ctx, "testrg123", "sitef6141", "12345", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BackupItem = armappservice.BackupItem{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/backups/12345"),
	// 	Properties: &armappservice.BackupItemProperties{
	// 		Name: to.Ptr("sitef6141_2023-01-01"),
	// 		BlobName: to.Ptr("sitef6141_2023-01-01"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-03T17:33:11.641Z"); return t}()),
	// 		Databases: []*armappservice.DatabaseBackupSetting{
	// 			{
	// 				Name: to.Ptr("backenddb"),
	// 				ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
	// 				ConnectionStringName: to.Ptr("backend"),
	// 				DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
	// 			},
	// 			{
	// 				Name: to.Ptr("statsdb"),
	// 				ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
	// 				ConnectionStringName: to.Ptr("stats"),
	// 				DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
	// 		}},
	// 		FinishedTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-05T17:33:11.641Z"); return t}()),
	// 		BackupID: to.Ptr[int32](12345),
	// 		LastRestoreTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-04T17:33:11.641Z"); return t}()),
	// 		Log: to.Ptr("Succeeded"),
	// 		Scheduled: to.Ptr(true),
	// 		SizeInBytes: to.Ptr[int64](56091883),
	// 		Status: to.Ptr(armappservice.BackupItemStatusInProgress),
	// 		StorageAccountURL: to.Ptr("DefaultEndpointsProtocol=https;AccountName=storagesample;AccountKey=<account-key>"),
	// 		WebsiteSizeInBytes: to.Ptr[int64](56091883),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/DeleteWebAppBackup.json
func ExampleWebAppsClient_DeleteBackup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().DeleteBackup(ctx, "testrg123", "sitef6141", "12345", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebAppBackupWithSecrets.json
func ExampleWebAppsClient_ListBackupStatusSecrets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().ListBackupStatusSecrets(ctx, "testrg123", "sitef6141", "12345", armappservice.BackupRequest{
		Properties: &armappservice.BackupRequestProperties{
			BackupName: to.Ptr("abcdwe"),
			BackupSchedule: &armappservice.BackupSchedule{
				FrequencyInterval:     to.Ptr[int32](7),
				FrequencyUnit:         to.Ptr(armappservice.FrequencyUnitDay),
				KeepAtLeastOneBackup:  to.Ptr(true),
				RetentionPeriodInDays: to.Ptr[int32](30),
				StartTime:             to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T17:33:11.641Z"); return t }()),
			},
			Databases: []*armappservice.DatabaseBackupSetting{
				{
					Name:                 to.Ptr("backenddb"),
					ConnectionString:     to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
					ConnectionStringName: to.Ptr("backend"),
					DatabaseType:         to.Ptr(armappservice.DatabaseTypeSQLAzure),
				},
				{
					Name:                 to.Ptr("statsdb"),
					ConnectionString:     to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
					ConnectionStringName: to.Ptr("stats"),
					DatabaseType:         to.Ptr(armappservice.DatabaseTypeSQLAzure),
				}},
			Enabled:           to.Ptr(true),
			StorageAccountURL: to.Ptr("DefaultEndpointsProtocol=https;AccountName=storagesample;AccountKey=<account-key>"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BackupItem = armappservice.BackupItem{
	// 	Name: to.Ptr("sitef6141"),
	// 	Type: to.Ptr("Microsoft.Web/sites"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/backups/12345"),
	// 	Properties: &armappservice.BackupItemProperties{
	// 		Name: to.Ptr("sitef6141_2023-01-01"),
	// 		BlobName: to.Ptr("sitef6141_2023-01-01"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-03T17:33:11.641Z"); return t}()),
	// 		Databases: []*armappservice.DatabaseBackupSetting{
	// 			{
	// 				Name: to.Ptr("backenddb"),
	// 				ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
	// 				ConnectionStringName: to.Ptr("backend"),
	// 				DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
	// 			},
	// 			{
	// 				Name: to.Ptr("statsdb"),
	// 				ConnectionString: to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
	// 				ConnectionStringName: to.Ptr("stats"),
	// 				DatabaseType: to.Ptr(armappservice.DatabaseTypeSQLAzure),
	// 		}},
	// 		FinishedTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-05T17:33:11.641Z"); return t}()),
	// 		BackupID: to.Ptr[int32](12345),
	// 		LastRestoreTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-04T17:33:11.641Z"); return t}()),
	// 		Log: to.Ptr("Succeeded"),
	// 		Scheduled: to.Ptr(true),
	// 		SizeInBytes: to.Ptr[int64](56091883),
	// 		Status: to.Ptr(armappservice.BackupItemStatusInProgress),
	// 		StorageAccountURL: to.Ptr("DefaultEndpointsProtocol=https;AccountName=storagesample;AccountKey=<account-key>"),
	// 		WebsiteSizeInBytes: to.Ptr[int64](56091883),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/RestoreWebAppBackup.json
func ExampleWebAppsClient_BeginRestore() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginRestore(ctx, "testrg123", "sitef6141", "123244", armappservice.RestoreRequest{
		Properties: &armappservice.RestoreRequestProperties{
			Databases: []*armappservice.DatabaseBackupSetting{
				{
					Name:                 to.Ptr("backenddb"),
					ConnectionString:     to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
					ConnectionStringName: to.Ptr("backend"),
					DatabaseType:         to.Ptr(armappservice.DatabaseTypeSQLAzure),
				},
				{
					Name:                 to.Ptr("statsdb"),
					ConnectionString:     to.Ptr("DSN=data-source-name[;SERVER=value] [;PWD=value] [;UID=value] [;<Attribute>=<value>]"),
					ConnectionStringName: to.Ptr("stats"),
					DatabaseType:         to.Ptr(armappservice.DatabaseTypeSQLAzure),
				}},
			Overwrite:         to.Ptr(true),
			SiteName:          to.Ptr("sitef6141"),
			StorageAccountURL: to.Ptr("DefaultEndpointsProtocol=https;AccountName=storagesample;AccountKey=<account-key>"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListPublishingCredentialsPolicies.json
func ExampleWebAppsClient_NewListBasicPublishingCredentialsPoliciesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListBasicPublishingCredentialsPoliciesPager("testrg123", "testsite", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PublishingCredentialsPoliciesCollection = armappservice.PublishingCredentialsPoliciesCollection{
		// 	Value: []*armappservice.CsmPublishingCredentialsPoliciesEntity{
		// 		{
		// 			Name: to.Ptr("ftp"),
		// 			Type: to.Ptr("Microsoft.Web/sites/basicPublishingCredentialsPolicies"),
		// 			ID: to.Ptr("/subscriptions/3fb8d758-2e2c-42e9-a528-a8acdfe87237/resourceGroups/testrg123/providers/Microsoft.Web/sites/testsite/basicPublishingCredentialsPolicies/ftp"),
		// 			Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
		// 				Allow: to.Ptr(true),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scm"),
		// 			Type: to.Ptr("Microsoft.Web/sites/basicPublishingCredentialsPolicies"),
		// 			ID: to.Ptr("/subscriptions/3fb8d758-2e2c-42e9-a528-a8acdfe87237/resourceGroups/testrg123/providers/Microsoft.Web/sites/testsite/basicPublishingCredentialsPolicies/scm"),
		// 			Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
		// 				Allow: to.Ptr(true),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetPublishingCredentialsPolicy.json
func ExampleWebAppsClient_GetFtpAllowed() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetFtpAllowed(ctx, "rg", "testSite", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CsmPublishingCredentialsPoliciesEntity = armappservice.CsmPublishingCredentialsPoliciesEntity{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/basicPublishingCredentialsPolicies/ftp"),
	// 	Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
	// 		Allow: to.Ptr(false),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdatePublishingCredentialsPolicy.json
func ExampleWebAppsClient_UpdateFtpAllowed() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().UpdateFtpAllowed(ctx, "rg", "testSite", armappservice.CsmPublishingCredentialsPoliciesEntity{
		Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
			Allow: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CsmPublishingCredentialsPoliciesEntity = armappservice.CsmPublishingCredentialsPoliciesEntity{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/basicPublishingCredentialsPolicies/ftp"),
	// 	Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
	// 		Allow: to.Ptr(true),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListWebAppConfigurations.json
func ExampleWebAppsClient_NewListConfigurationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListConfigurationsPager("testrg123", "sitef6141", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SiteConfigResourceCollection = armappservice.SiteConfigResourceCollection{
		// 	Value: []*armappservice.SiteConfigResource{
		// 		{
		// 			Name: to.Ptr("web"),
		// 			Type: to.Ptr("Microsoft.Web/sites/config"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/web"),
		// 			Kind: to.Ptr("app"),
		// 			Properties: &armappservice.SiteConfig{
		// 				AcrUseManagedIdentityCreds: to.Ptr(false),
		// 				AlwaysOn: to.Ptr(false),
		// 				AppCommandLine: to.Ptr(""),
		// 				AutoHealEnabled: to.Ptr(false),
		// 				AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
		// 				},
		// 				DefaultDocuments: []*string{
		// 					to.Ptr("Default.htm"),
		// 					to.Ptr("Default.html"),
		// 					to.Ptr("Default.asp"),
		// 					to.Ptr("index.htm"),
		// 					to.Ptr("index.html"),
		// 					to.Ptr("iisstart.htm"),
		// 					to.Ptr("default.aspx"),
		// 					to.Ptr("index.php"),
		// 					to.Ptr("hostingstart.html")},
		// 					DetailedErrorLoggingEnabled: to.Ptr(false),
		// 					FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
		// 					FunctionAppScaleLimit: to.Ptr[int32](0),
		// 					FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
		// 					Http20Enabled: to.Ptr(false),
		// 					HTTPLoggingEnabled: to.Ptr(false),
		// 					LinuxFxVersion: to.Ptr(""),
		// 					LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
		// 					LogsDirectorySizeLimit: to.Ptr[int32](35),
		// 					ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
		// 					MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 					MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 					NetFrameworkVersion: to.Ptr("v4.0"),
		// 					NodeVersion: to.Ptr(""),
		// 					NumberOfWorkers: to.Ptr[int32](1),
		// 					PhpVersion: to.Ptr("5.6"),
		// 					PowerShellVersion: to.Ptr(""),
		// 					PythonVersion: to.Ptr(""),
		// 					RemoteDebuggingEnabled: to.Ptr(false),
		// 					RequestTracingEnabled: to.Ptr(false),
		// 					ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 					Use32BitWorkerProcess: to.Ptr(true),
		// 					VirtualApplications: []*armappservice.VirtualApplication{
		// 						{
		// 							PhysicalPath: to.Ptr("site\\wwwroot"),
		// 							PreloadEnabled: to.Ptr(false),
		// 							VirtualPath: to.Ptr("/"),
		// 					}},
		// 					VnetName: to.Ptr(""),
		// 					VnetPrivatePortsCount: to.Ptr[int32](0),
		// 					VnetRouteAllEnabled: to.Ptr(false),
		// 					WebSocketsEnabled: to.Ptr(false),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateAppSettings.json
func ExampleWebAppsClient_UpdateApplicationSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().UpdateApplicationSettings(ctx, "testrg123", "sitef6141", armappservice.StringDictionary{
		Properties: map[string]*string{
			"Setting1": to.Ptr("Value1"),
			"Setting2": to.Ptr("Value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StringDictionary = armappservice.StringDictionary{
	// 	Name: to.Ptr("appsettings"),
	// 	Type: to.Ptr("Microsoft.Web/sites/config"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/appsettings"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: map[string]*string{
	// 		"Setting1": to.Ptr("Value1"),
	// 		"Setting2": to.Ptr("Value2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListAppSettings.json
func ExampleWebAppsClient_ListApplicationSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().ListApplicationSettings(ctx, "testrg123", "sitef6141", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StringDictionary = armappservice.StringDictionary{
	// 	Name: to.Ptr("appsettings"),
	// 	Type: to.Ptr("Microsoft.Web/sites/config"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/appsettings"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: map[string]*string{
	// 		"Setting1": to.Ptr("Value1"),
	// 		"Setting2": to.Ptr("Value2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateAuthSettings.json
func ExampleWebAppsClient_UpdateAuthSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().UpdateAuthSettings(ctx, "testrg123", "sitef6141", armappservice.SiteAuthSettings{
		Properties: &armappservice.SiteAuthSettingsProperties{
			AllowedExternalRedirectUrls: []*string{
				to.Ptr("sitef6141.customdomain.net"),
				to.Ptr("sitef6141.customdomain.info")},
			ClientID:                    to.Ptr("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
			DefaultProvider:             to.Ptr(armappservice.BuiltInAuthenticationProviderGoogle),
			Enabled:                     to.Ptr(true),
			RuntimeVersion:              to.Ptr("~1"),
			TokenRefreshExtensionHours:  to.Ptr[float64](120),
			TokenStoreEnabled:           to.Ptr(true),
			UnauthenticatedClientAction: to.Ptr(armappservice.UnauthenticatedClientActionRedirectToLoginPage),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteAuthSettings = armappservice.SiteAuthSettings{
	// 	Name: to.Ptr("authsettings"),
	// 	Type: to.Ptr("Microsoft.Web/sites/authsettings"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/authsettings"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: &armappservice.SiteAuthSettingsProperties{
	// 		AllowedExternalRedirectUrls: []*string{
	// 			to.Ptr("sitef6141.customdomain.net"),
	// 			to.Ptr("sitef6141.customdomain.info")},
	// 			ClientID: to.Ptr("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
	// 			DefaultProvider: to.Ptr(armappservice.BuiltInAuthenticationProviderGoogle),
	// 			Enabled: to.Ptr(true),
	// 			RuntimeVersion: to.Ptr("~1"),
	// 			TokenRefreshExtensionHours: to.Ptr[float64](120),
	// 			TokenStoreEnabled: to.Ptr(true),
	// 			UnauthenticatedClientAction: to.Ptr(armappservice.UnauthenticatedClientActionRedirectToLoginPage),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListAuthSettings.json
func ExampleWebAppsClient_GetAuthSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetAuthSettings(ctx, "testrg123", "sitef6141", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteAuthSettings = armappservice.SiteAuthSettings{
	// 	Name: to.Ptr("authsettings"),
	// 	Type: to.Ptr("Microsoft.Web/sites/authsettings"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/authsettings"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: &armappservice.SiteAuthSettingsProperties{
	// 		AllowedExternalRedirectUrls: []*string{
	// 			to.Ptr("sitef6141.customdomain.net"),
	// 			to.Ptr("sitef6141.customdomain.info")},
	// 			ClientID: to.Ptr("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
	// 			DefaultProvider: to.Ptr(armappservice.BuiltInAuthenticationProviderGoogle),
	// 			Enabled: to.Ptr(true),
	// 			RuntimeVersion: to.Ptr("~1"),
	// 			TokenRefreshExtensionHours: to.Ptr[float64](120),
	// 			TokenStoreEnabled: to.Ptr(true),
	// 			UnauthenticatedClientAction: to.Ptr(armappservice.UnauthenticatedClientActionRedirectToLoginPage),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetAuthSettingsV2WithoutSecrets.json
func ExampleWebAppsClient_GetAuthSettingsV2WithoutSecrets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetAuthSettingsV2WithoutSecrets(ctx, "testrg123", "sitef6141", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteAuthSettingsV2 = armappservice.SiteAuthSettingsV2{
	// 	Name: to.Ptr("authsettingsv2"),
	// 	Type: to.Ptr("Microsoft.Web/sites/authsettingsv2"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/authsettingsv2"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: &armappservice.SiteAuthSettingsV2Properties{
	// 		GlobalValidation: &armappservice.GlobalValidation{
	// 			ExcludedPaths: []*string{
	// 				to.Ptr("/nosecrets/Path")},
	// 				RequireAuthentication: to.Ptr(true),
	// 				UnauthenticatedClientAction: to.Ptr(armappservice.UnauthenticatedClientActionV2Return403),
	// 			},
	// 			HTTPSettings: &armappservice.HTTPSettings{
	// 				ForwardProxy: &armappservice.ForwardProxy{
	// 					Convention: to.Ptr(armappservice.ForwardProxyConventionStandard),
	// 					CustomHostHeaderName: to.Ptr("authHeader"),
	// 					CustomProtoHeaderName: to.Ptr("customProtoHeader"),
	// 				},
	// 				RequireHTTPS: to.Ptr(true),
	// 				Routes: &armappservice.HTTPSettingsRoutes{
	// 					APIPrefix: to.Ptr("/authv2/"),
	// 				},
	// 			},
	// 			IdentityProviders: &armappservice.IdentityProviders{
	// 				Google: &armappservice.Google{
	// 					Enabled: to.Ptr(true),
	// 					Login: &armappservice.LoginScopes{
	// 						Scopes: []*string{
	// 							to.Ptr("admin")},
	// 						},
	// 						Registration: &armappservice.ClientRegistration{
	// 							ClientID: to.Ptr("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
	// 							ClientSecretSettingName: to.Ptr("ClientSecret"),
	// 						},
	// 						Validation: &armappservice.AllowedAudiencesValidation{
	// 							AllowedAudiences: []*string{
	// 								to.Ptr("https://example.com")},
	// 							},
	// 						},
	// 					},
	// 					Login: &armappservice.Login{
	// 						AllowedExternalRedirectUrls: []*string{
	// 							to.Ptr("https://someurl.com")},
	// 							CookieExpiration: &armappservice.CookieExpiration{
	// 								Convention: to.Ptr(armappservice.CookieExpirationConventionIdentityProviderDerived),
	// 								TimeToExpiration: to.Ptr("2022:09-01T00:00Z"),
	// 							},
	// 							Nonce: &armappservice.Nonce{
	// 								ValidateNonce: to.Ptr(true),
	// 							},
	// 							PreserveURLFragmentsForLogins: to.Ptr(true),
	// 							Routes: &armappservice.LoginRoutes{
	// 								LogoutEndpoint: to.Ptr("https://app.com/logout"),
	// 							},
	// 							TokenStore: &armappservice.TokenStore{
	// 								Enabled: to.Ptr(true),
	// 								FileSystem: &armappservice.FileSystemTokenStore{
	// 									Directory: to.Ptr("/wwwroot/sites/example"),
	// 								},
	// 								TokenRefreshExtensionHours: to.Ptr[float64](96),
	// 							},
	// 						},
	// 						Platform: &armappservice.AuthPlatform{
	// 							ConfigFilePath: to.Ptr("/auth/config.json"),
	// 							Enabled: to.Ptr(true),
	// 							RuntimeVersion: to.Ptr("~1"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateAuthSettingsV2.json
func ExampleWebAppsClient_UpdateAuthSettingsV2() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().UpdateAuthSettingsV2(ctx, "testrg123", "sitef6141", armappservice.SiteAuthSettingsV2{
		Properties: &armappservice.SiteAuthSettingsV2Properties{
			GlobalValidation: &armappservice.GlobalValidation{
				ExcludedPaths: []*string{
					to.Ptr("/nosecrets/Path")},
				RequireAuthentication:       to.Ptr(true),
				UnauthenticatedClientAction: to.Ptr(armappservice.UnauthenticatedClientActionV2Return403),
			},
			HTTPSettings: &armappservice.HTTPSettings{
				ForwardProxy: &armappservice.ForwardProxy{
					Convention:            to.Ptr(armappservice.ForwardProxyConventionStandard),
					CustomHostHeaderName:  to.Ptr("authHeader"),
					CustomProtoHeaderName: to.Ptr("customProtoHeader"),
				},
				RequireHTTPS: to.Ptr(true),
				Routes: &armappservice.HTTPSettingsRoutes{
					APIPrefix: to.Ptr("/authv2/"),
				},
			},
			IdentityProviders: &armappservice.IdentityProviders{
				Google: &armappservice.Google{
					Enabled: to.Ptr(true),
					Login: &armappservice.LoginScopes{
						Scopes: []*string{
							to.Ptr("admin")},
					},
					Registration: &armappservice.ClientRegistration{
						ClientID:                to.Ptr("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
						ClientSecretSettingName: to.Ptr("ClientSecret"),
					},
					Validation: &armappservice.AllowedAudiencesValidation{
						AllowedAudiences: []*string{
							to.Ptr("https://example.com")},
					},
				},
			},
			Login: &armappservice.Login{
				AllowedExternalRedirectUrls: []*string{
					to.Ptr("https://someurl.com")},
				CookieExpiration: &armappservice.CookieExpiration{
					Convention:       to.Ptr(armappservice.CookieExpirationConventionIdentityProviderDerived),
					TimeToExpiration: to.Ptr("2022:09-01T00:00Z"),
				},
				Nonce: &armappservice.Nonce{
					ValidateNonce: to.Ptr(true),
				},
				PreserveURLFragmentsForLogins: to.Ptr(true),
				Routes: &armappservice.LoginRoutes{
					LogoutEndpoint: to.Ptr("https://app.com/logout"),
				},
				TokenStore: &armappservice.TokenStore{
					Enabled: to.Ptr(true),
					FileSystem: &armappservice.FileSystemTokenStore{
						Directory: to.Ptr("/wwwroot/sites/example"),
					},
					TokenRefreshExtensionHours: to.Ptr[float64](96),
				},
			},
			Platform: &armappservice.AuthPlatform{
				ConfigFilePath: to.Ptr("/auth/config.json"),
				Enabled:        to.Ptr(true),
				RuntimeVersion: to.Ptr("~1"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteAuthSettingsV2 = armappservice.SiteAuthSettingsV2{
	// 	Name: to.Ptr("authsettingsv2"),
	// 	Type: to.Ptr("Microsoft.Web/sites/authsettingsv2"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/authsettingsv2"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: &armappservice.SiteAuthSettingsV2Properties{
	// 		GlobalValidation: &armappservice.GlobalValidation{
	// 			ExcludedPaths: []*string{
	// 				to.Ptr("/nosecrets/Path")},
	// 				RequireAuthentication: to.Ptr(true),
	// 				UnauthenticatedClientAction: to.Ptr(armappservice.UnauthenticatedClientActionV2Return403),
	// 			},
	// 			HTTPSettings: &armappservice.HTTPSettings{
	// 				ForwardProxy: &armappservice.ForwardProxy{
	// 					Convention: to.Ptr(armappservice.ForwardProxyConventionStandard),
	// 					CustomHostHeaderName: to.Ptr("authHeader"),
	// 					CustomProtoHeaderName: to.Ptr("customProtoHeader"),
	// 				},
	// 				RequireHTTPS: to.Ptr(true),
	// 				Routes: &armappservice.HTTPSettingsRoutes{
	// 					APIPrefix: to.Ptr("/authv2/"),
	// 				},
	// 			},
	// 			IdentityProviders: &armappservice.IdentityProviders{
	// 				Google: &armappservice.Google{
	// 					Enabled: to.Ptr(true),
	// 					Login: &armappservice.LoginScopes{
	// 						Scopes: []*string{
	// 							to.Ptr("admin")},
	// 						},
	// 						Registration: &armappservice.ClientRegistration{
	// 							ClientID: to.Ptr("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
	// 							ClientSecretSettingName: to.Ptr("ClientSecret"),
	// 						},
	// 						Validation: &armappservice.AllowedAudiencesValidation{
	// 							AllowedAudiences: []*string{
	// 								to.Ptr("https://example.com")},
	// 							},
	// 						},
	// 					},
	// 					Login: &armappservice.Login{
	// 						AllowedExternalRedirectUrls: []*string{
	// 							to.Ptr("https://someurl.com")},
	// 							CookieExpiration: &armappservice.CookieExpiration{
	// 								Convention: to.Ptr(armappservice.CookieExpirationConventionIdentityProviderDerived),
	// 								TimeToExpiration: to.Ptr("2022:09-01T00:00Z"),
	// 							},
	// 							Nonce: &armappservice.Nonce{
	// 								ValidateNonce: to.Ptr(true),
	// 							},
	// 							PreserveURLFragmentsForLogins: to.Ptr(true),
	// 							Routes: &armappservice.LoginRoutes{
	// 								LogoutEndpoint: to.Ptr("https://app.com/logout"),
	// 							},
	// 							TokenStore: &armappservice.TokenStore{
	// 								Enabled: to.Ptr(true),
	// 								FileSystem: &armappservice.FileSystemTokenStore{
	// 									Directory: to.Ptr("/wwwroot/sites/example"),
	// 								},
	// 								TokenRefreshExtensionHours: to.Ptr[float64](96),
	// 							},
	// 						},
	// 						Platform: &armappservice.AuthPlatform{
	// 							ConfigFilePath: to.Ptr("/auth/config.json"),
	// 							Enabled: to.Ptr(true),
	// 							RuntimeVersion: to.Ptr("~1"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListAuthSettingsV2.json
func ExampleWebAppsClient_GetAuthSettingsV2() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetAuthSettingsV2(ctx, "testrg123", "sitef6141", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteAuthSettingsV2 = armappservice.SiteAuthSettingsV2{
	// 	Name: to.Ptr("authsettingsv2"),
	// 	Type: to.Ptr("Microsoft.Web/sites/authsettingsv2"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/authsettingsv2"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: &armappservice.SiteAuthSettingsV2Properties{
	// 		GlobalValidation: &armappservice.GlobalValidation{
	// 			ExcludedPaths: []*string{
	// 				to.Ptr("/nosecrets/Path")},
	// 				RequireAuthentication: to.Ptr(true),
	// 				UnauthenticatedClientAction: to.Ptr(armappservice.UnauthenticatedClientActionV2Return403),
	// 			},
	// 			HTTPSettings: &armappservice.HTTPSettings{
	// 				ForwardProxy: &armappservice.ForwardProxy{
	// 					Convention: to.Ptr(armappservice.ForwardProxyConventionStandard),
	// 					CustomHostHeaderName: to.Ptr("authHeader"),
	// 					CustomProtoHeaderName: to.Ptr("customProtoHeader"),
	// 				},
	// 				RequireHTTPS: to.Ptr(true),
	// 				Routes: &armappservice.HTTPSettingsRoutes{
	// 					APIPrefix: to.Ptr("/authv2/"),
	// 				},
	// 			},
	// 			IdentityProviders: &armappservice.IdentityProviders{
	// 				Google: &armappservice.Google{
	// 					Enabled: to.Ptr(true),
	// 					Login: &armappservice.LoginScopes{
	// 						Scopes: []*string{
	// 							to.Ptr("admin")},
	// 						},
	// 						Registration: &armappservice.ClientRegistration{
	// 							ClientID: to.Ptr("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
	// 							ClientSecretSettingName: to.Ptr("ClientSecret"),
	// 						},
	// 						Validation: &armappservice.AllowedAudiencesValidation{
	// 							AllowedAudiences: []*string{
	// 								to.Ptr("https://example.com")},
	// 							},
	// 						},
	// 					},
	// 					Login: &armappservice.Login{
	// 						AllowedExternalRedirectUrls: []*string{
	// 							to.Ptr("https://someurl.com")},
	// 							CookieExpiration: &armappservice.CookieExpiration{
	// 								Convention: to.Ptr(armappservice.CookieExpirationConventionIdentityProviderDerived),
	// 								TimeToExpiration: to.Ptr("2022:09-01T00:00Z"),
	// 							},
	// 							Nonce: &armappservice.Nonce{
	// 								ValidateNonce: to.Ptr(true),
	// 							},
	// 							PreserveURLFragmentsForLogins: to.Ptr(true),
	// 							Routes: &armappservice.LoginRoutes{
	// 								LogoutEndpoint: to.Ptr("https://app.com/logout"),
	// 							},
	// 							TokenStore: &armappservice.TokenStore{
	// 								Enabled: to.Ptr(true),
	// 								FileSystem: &armappservice.FileSystemTokenStore{
	// 									Directory: to.Ptr("/wwwroot/sites/example"),
	// 								},
	// 								TokenRefreshExtensionHours: to.Ptr[float64](96),
	// 							},
	// 						},
	// 						Platform: &armappservice.AuthPlatform{
	// 							ConfigFilePath: to.Ptr("/auth/config.json"),
	// 							Enabled: to.Ptr(true),
	// 							RuntimeVersion: to.Ptr("~1"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateAzureStorageAccounts.json
func ExampleWebAppsClient_UpdateAzureStorageAccounts() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().UpdateAzureStorageAccounts(ctx, "testrg123", "sitef6141", armappservice.AzureStoragePropertyDictionaryResource{
		Properties: map[string]*armappservice.AzureStorageInfoValue{
			"account1": {
				Type:        to.Ptr(armappservice.AzureStorageTypeAzureFiles),
				AccessKey:   to.Ptr("26515^%@#*"),
				AccountName: to.Ptr("testsa"),
				MountPath:   to.Ptr("/mounts/a/files"),
				ShareName:   to.Ptr("web"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureStoragePropertyDictionaryResource = armappservice.AzureStoragePropertyDictionaryResource{
	// 	Name: to.Ptr("web"),
	// 	Type: to.Ptr("Microsoft.Web/sites/config"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/web"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: map[string]*armappservice.AzureStorageInfoValue{
	// 		"account1": &armappservice.AzureStorageInfoValue{
	// 			Type: to.Ptr(armappservice.AzureStorageTypeAzureFiles),
	// 			AccountName: to.Ptr("testsa"),
	// 			MountPath: to.Ptr("/mounts/a/files"),
	// 			ShareName: to.Ptr("web"),
	// 			State: to.Ptr(armappservice.AzureStorageStateOk),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetKeyVaultReferencesForAppSettings.json
func ExampleWebAppsClient_NewGetAppSettingsKeyVaultReferencesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewGetAppSettingsKeyVaultReferencesPager("testrg123", "testc6282", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.APIKVReferenceCollection = armappservice.APIKVReferenceCollection{
		// 	Value: []*armappservice.APIKVReference{
		// 		{
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testc6282/config/configreferences/appsettings/secretName"),
		// 			Properties: &armappservice.APIKVReferenceProperties{
		// 				SecretName: to.Ptr("secretName"),
		// 				SecretVersion: to.Ptr("secretVersion"),
		// 				VaultName: to.Ptr("keyVaultName"),
		// 			},
		// 		},
		// 		{
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testc6282/config/configreferences/appsettings/secretName2"),
		// 			Properties: &armappservice.APIKVReferenceProperties{
		// 				SecretName: to.Ptr("secretName2"),
		// 				SecretVersion: to.Ptr("secretVersion2"),
		// 				VaultName: to.Ptr("keyVaultName"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetKeyVaultReferencesForAppSetting.json
func ExampleWebAppsClient_GetAppSettingKeyVaultReference() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetAppSettingKeyVaultReference(ctx, "testrg123", "testc6282", "setting", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.APIKVReference = armappservice.APIKVReference{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testc6282/config/configreferences/appsettings/setting"),
	// 	Properties: &armappservice.APIKVReferenceProperties{
	// 		SecretName: to.Ptr("secretName"),
	// 		SecretVersion: to.Ptr("secretVersion"),
	// 		VaultName: to.Ptr("keyVaultName"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSiteConfig.json
func ExampleWebAppsClient_GetConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetConfiguration(ctx, "testrg123", "sitef6141", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteConfigResource = armappservice.SiteConfigResource{
	// 	Name: to.Ptr("web"),
	// 	Type: to.Ptr("Microsoft.Web/sites/config"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/web"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: &armappservice.SiteConfig{
	// 		AcrUseManagedIdentityCreds: to.Ptr(false),
	// 		AlwaysOn: to.Ptr(false),
	// 		AppCommandLine: to.Ptr(""),
	// 		AutoHealEnabled: to.Ptr(false),
	// 		AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 		},
	// 		DefaultDocuments: []*string{
	// 			to.Ptr("Default.htm"),
	// 			to.Ptr("Default.html"),
	// 			to.Ptr("Default.asp"),
	// 			to.Ptr("index.htm"),
	// 			to.Ptr("index.html"),
	// 			to.Ptr("iisstart.htm"),
	// 			to.Ptr("default.aspx"),
	// 			to.Ptr("index.php"),
	// 			to.Ptr("hostingstart.html")},
	// 			DetailedErrorLoggingEnabled: to.Ptr(false),
	// 			FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 			FunctionAppScaleLimit: to.Ptr[int32](0),
	// 			FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 			Http20Enabled: to.Ptr(false),
	// 			HTTPLoggingEnabled: to.Ptr(false),
	// 			LinuxFxVersion: to.Ptr(""),
	// 			LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 			LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 			ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 			MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 			MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 			NetFrameworkVersion: to.Ptr("v4.0"),
	// 			NodeVersion: to.Ptr(""),
	// 			NumberOfWorkers: to.Ptr[int32](1),
	// 			PhpVersion: to.Ptr("5.6"),
	// 			PowerShellVersion: to.Ptr(""),
	// 			PythonVersion: to.Ptr(""),
	// 			RemoteDebuggingEnabled: to.Ptr(false),
	// 			RequestTracingEnabled: to.Ptr(false),
	// 			ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 			Use32BitWorkerProcess: to.Ptr(true),
	// 			VirtualApplications: []*armappservice.VirtualApplication{
	// 				{
	// 					PhysicalPath: to.Ptr("site\\wwwroot"),
	// 					PreloadEnabled: to.Ptr(false),
	// 					VirtualPath: to.Ptr("/"),
	// 			}},
	// 			VnetName: to.Ptr(""),
	// 			VnetPrivatePortsCount: to.Ptr[int32](0),
	// 			VnetRouteAllEnabled: to.Ptr(false),
	// 			WebSocketsEnabled: to.Ptr(false),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateSiteConfig.json
func ExampleWebAppsClient_CreateOrUpdateConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().CreateOrUpdateConfiguration(ctx, "testrg123", "sitef6141", armappservice.SiteConfigResource{
		Properties: &armappservice.SiteConfig{
			AcrUseManagedIdentityCreds: to.Ptr(false),
			AlwaysOn:                   to.Ptr(false),
			AppCommandLine:             to.Ptr(""),
			AutoHealEnabled:            to.Ptr(false),
			AzureStorageAccounts:       map[string]*armappservice.AzureStorageInfoValue{},
			DefaultDocuments: []*string{
				to.Ptr("Default.htm"),
				to.Ptr("Default.html"),
				to.Ptr("Default.asp"),
				to.Ptr("index.htm"),
				to.Ptr("index.html"),
				to.Ptr("iisstart.htm"),
				to.Ptr("default.aspx"),
				to.Ptr("index.php"),
				to.Ptr("hostingstart.html")},
			DetailedErrorLoggingEnabled:            to.Ptr(false),
			FtpsState:                              to.Ptr(armappservice.FtpsStateAllAllowed),
			FunctionAppScaleLimit:                  to.Ptr[int32](0),
			FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
			Http20Enabled:                          to.Ptr(false),
			HTTPLoggingEnabled:                     to.Ptr(false),
			LinuxFxVersion:                         to.Ptr(""),
			LoadBalancing:                          to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
			LogsDirectorySizeLimit:                 to.Ptr[int32](35),
			ManagedPipelineMode:                    to.Ptr(armappservice.ManagedPipelineModeIntegrated),
			MinTLSVersion:                          to.Ptr(armappservice.SupportedTLSVersionsOne2),
			MinimumElasticInstanceCount:            to.Ptr[int32](0),
			NetFrameworkVersion:                    to.Ptr("v4.0"),
			NodeVersion:                            to.Ptr(""),
			NumberOfWorkers:                        to.Ptr[int32](1),
			PhpVersion:                             to.Ptr("5.6"),
			PowerShellVersion:                      to.Ptr(""),
			PythonVersion:                          to.Ptr(""),
			RemoteDebuggingEnabled:                 to.Ptr(false),
			RequestTracingEnabled:                  to.Ptr(false),
			ScmMinTLSVersion:                       to.Ptr(armappservice.SupportedTLSVersionsOne2),
			Use32BitWorkerProcess:                  to.Ptr(true),
			VirtualApplications: []*armappservice.VirtualApplication{
				{
					PhysicalPath:   to.Ptr("site\\wwwroot"),
					PreloadEnabled: to.Ptr(false),
					VirtualPath:    to.Ptr("/"),
				}},
			VnetName:              to.Ptr(""),
			VnetPrivatePortsCount: to.Ptr[int32](0),
			VnetRouteAllEnabled:   to.Ptr(false),
			WebSocketsEnabled:     to.Ptr(false),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SiteConfigResource = armappservice.SiteConfigResource{
	// 	Name: to.Ptr("web"),
	// 	Type: to.Ptr("Microsoft.Web/sites/config"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/config/web"),
	// 	Kind: to.Ptr("app"),
	// 	Properties: &armappservice.SiteConfig{
	// 		AcrUseManagedIdentityCreds: to.Ptr(false),
	// 		AlwaysOn: to.Ptr(false),
	// 		AppCommandLine: to.Ptr(""),
	// 		AutoHealEnabled: to.Ptr(false),
	// 		AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 		},
	// 		DefaultDocuments: []*string{
	// 			to.Ptr("Default.htm"),
	// 			to.Ptr("Default.html"),
	// 			to.Ptr("Default.asp"),
	// 			to.Ptr("index.htm"),
	// 			to.Ptr("index.html"),
	// 			to.Ptr("iisstart.htm"),
	// 			to.Ptr("default.aspx"),
	// 			to.Ptr("index.php"),
	// 			to.Ptr("hostingstart.html")},
	// 			DetailedErrorLoggingEnabled: to.Ptr(false),
	// 			FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 			FunctionAppScaleLimit: to.Ptr[int32](0),
	// 			FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 			Http20Enabled: to.Ptr(false),
	// 			HTTPLoggingEnabled: to.Ptr(false),
	// 			LinuxFxVersion: to.Ptr(""),
	// 			LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 			LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 			ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 			MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 			MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 			NetFrameworkVersion: to.Ptr("v4.0"),
	// 			NodeVersion: to.Ptr(""),
	// 			NumberOfWorkers: to.Ptr[int32](1),
	// 			PhpVersion: to.Ptr("5.6"),
	// 			PowerShellVersion: to.Ptr(""),
	// 			PythonVersion: to.Ptr(""),
	// 			RemoteDebuggingEnabled: to.Ptr(false),
	// 			RequestTracingEnabled: to.Ptr(false),
	// 			ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 			Use32BitWorkerProcess: to.Ptr(true),
	// 			VirtualApplications: []*armappservice.VirtualApplication{
	// 				{
	// 					PhysicalPath: to.Ptr("site\\wwwroot"),
	// 					PreloadEnabled: to.Ptr(false),
	// 					VirtualPath: to.Ptr("/"),
	// 			}},
	// 			VnetName: to.Ptr(""),
	// 			VnetPrivatePortsCount: to.Ptr[int32](0),
	// 			VnetRouteAllEnabled: to.Ptr(false),
	// 			WebSocketsEnabled: to.Ptr(false),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListSiteDeploymentStatus.json
func ExampleWebAppsClient_NewListProductionSiteDeploymentStatusesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListProductionSiteDeploymentStatusesPager("rg", "testSite", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CsmDeploymentStatusCollection = armappservice.CsmDeploymentStatusCollection{
		// 	Value: []*armappservice.CsmDeploymentStatus{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSiteDeploymentStatus.json
func ExampleWebAppsClient_BeginGetProductionSiteDeploymentStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginGetProductionSiteDeploymentStatus(ctx, "rg", "testSite", "eacfd68b-3bbd-4ad9-99c5-98614d89c8e5", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CsmDeploymentStatus = armappservice.CsmDeploymentStatus{
	// 	Name: to.Ptr("eacfd68b-3bbd-4ad9-99c5-98614d89c8e5"),
	// 	Type: to.Ptr("Microsoft.Web/sites/deploymentStatus"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/deploymentStatus/eacfd68b-3bbd-4ad9-99c5-98614d89c8e5"),
	// 	Properties: &armappservice.CsmDeploymentStatusProperties{
	// 		DeploymentID: to.Ptr("eacfd68b-3bbd-4ad9-99c5-98614d89c8e5"),
	// 		FailedInstancesLogs: []*string{
	// 		},
	// 		NumberOfInstancesFailed: to.Ptr[int32](0),
	// 		NumberOfInstancesInProgress: to.Ptr[int32](0),
	// 		NumberOfInstancesSuccessful: to.Ptr[int32](1),
	// 		Status: to.Ptr(armappservice.DeploymentBuildStatusRuntimeSuccessful),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSiteInstanceInfo.json
func ExampleWebAppsClient_GetInstanceInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetInstanceInfo(ctx, "testrg123", "tests346", "134987120", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WebSiteInstanceStatus = armappservice.WebSiteInstanceStatus{
	// 	Name: to.Ptr("134987120"),
	// 	Type: to.Ptr("Microsoft.Web/sites/instances"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/tests346/slot/staging/instances/134987120"),
	// 	Properties: &armappservice.WebSiteInstanceStatusProperties{
	// 		Containers: map[string]*armappservice.ContainerInfo{
	// 			"c1": &armappservice.ContainerInfo{
	// 				CurrentTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2013-10-21T13:28:06.419Z"); return t}()),
	// 			},
	// 		},
	// 		DetectorURL: to.Ptr("testsec579"),
	// 		State: to.Ptr(armappservice.SiteRuntimeStateREADY),
	// 		StatusURL: to.Ptr("https://sampleurl"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListSlotBackups.json
func ExampleWebAppsClient_NewListSiteBackupsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListSiteBackupsPager("testrg123", "tests346", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.BackupItemCollection = armappservice.BackupItemCollection{
		// 	Value: []*armappservice.BackupItem{
		// 		{
		// 			Name: to.Ptr("tests346/staging"),
		// 			Type: to.Ptr("Microsoft.Web/sites/slots"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/tests346/slot/staging"),
		// 			Properties: &armappservice.BackupItemProperties{
		// 				BlobName: to.Ptr("blob1"),
		// 				Status: to.Ptr(armappservice.BackupItemStatusInProgress),
		// 				StorageAccountURL: to.Ptr("https://blobstorage.windows.net"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebSiteNetworkTraceOperation.json
func ExampleWebAppsClient_GetNetworkTraceOperation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetNetworkTraceOperation(ctx, "testrg123", "SampleApp", "c291433b-53ad-4c49-8cae-0a293eae1c6d", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkTraceArray = []*armappservice.NetworkTrace{
	// 	{
	// 		Path: to.Ptr("D:\\home\\LogFiles\\networktrace\\10.0.0.1_2018_02_01T00_00_00.zip"),
	// 		Message: to.Ptr("Trace file has been saved as D:\\home\\LogFiles\\networktrace\\10.0.0.1_2018_02_01T00_00_00.zip"),
	// 		Status: to.Ptr("Succeeded"),
	// }}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/StartWebSiteNetworkTraceOperation.json
func ExampleWebAppsClient_BeginStartWebSiteNetworkTraceOperation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginStartWebSiteNetworkTraceOperation(ctx, "testrg123", "SampleApp", &armappservice.WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions{DurationInSeconds: to.Ptr[int32](60),
		MaxFrameLength: nil,
		SasURL:         nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkTraceArray = []*armappservice.NetworkTrace{
	// 	{
	// 		Path: to.Ptr("D:\\home\\LogFiles\\networktrace\\10.0.0.1_2018_02_01T00_00_00.zip"),
	// 		Message: to.Ptr("Trace file has been saved as D:\\home\\LogFiles\\networktrace\\10.0.0.1_2018_02_01T00_00_00.zip"),
	// 		Status: to.Ptr("Succeeded"),
	// }}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/StopWebSiteNetworkTrace.json
func ExampleWebAppsClient_StopWebSiteNetworkTrace() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().StopWebSiteNetworkTrace(ctx, "testrg123", "SampleApp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebSiteNetworkTraces.json
func ExampleWebAppsClient_GetNetworkTraces() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetNetworkTraces(ctx, "testrg123", "SampleApp", "c291433b-53ad-4c49-8cae-0a293eae1c6d", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkTraceArray = []*armappservice.NetworkTrace{
	// 	{
	// 		Path: to.Ptr("D:\\home\\LogFiles\\networktrace\\10.0.0.1_2018_02_01T00_00_00.zip"),
	// 		Message: to.Ptr("Trace file has been saved as D:\\home\\LogFiles\\networktrace\\10.0.0.1_2018_02_01T00_00_00.zip"),
	// 		Status: to.Ptr("Succeeded"),
	// }}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSitePrivateEndpointConnection.json
func ExampleWebAppsClient_GetPrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetPrivateEndpointConnection(ctx, "rg", "testSite", "connection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemotePrivateEndpointConnectionARMResource = armappservice.RemotePrivateEndpointConnectionARMResource{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/privateEndpointConnections/connection"),
	// 	Properties: &armappservice.RemotePrivateEndpointConnectionARMResourceProperties{
	// 		PrivateEndpoint: &armappservice.ArmIDWrapper{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
	// 			Description: to.Ptr("Approved by admin."),
	// 			ActionsRequired: to.Ptr(""),
	// 			Status: to.Ptr("Approved"),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ApproveRejectSitePrivateEndpointConnection.json
func ExampleWebAppsClient_BeginApproveOrRejectPrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginApproveOrRejectPrivateEndpointConnection(ctx, "rg", "testSite", "connection", armappservice.PrivateLinkConnectionApprovalRequestResource{
		Properties: &armappservice.PrivateLinkConnectionApprovalRequest{
			PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
				Description:     to.Ptr("Approved by admin."),
				ActionsRequired: to.Ptr(""),
				Status:          to.Ptr("Approved"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemotePrivateEndpointConnectionARMResource = armappservice.RemotePrivateEndpointConnectionARMResource{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/privateEndpointConnections/connection"),
	// 	Properties: &armappservice.RemotePrivateEndpointConnectionARMResourceProperties{
	// 		PrivateEndpoint: &armappservice.ArmIDWrapper{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
	// 			Description: to.Ptr("Approved by admin."),
	// 			ActionsRequired: to.Ptr(""),
	// 			Status: to.Ptr("Approved"),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/DeleteSitePrivateEndpointConnection.json
func ExampleWebAppsClient_BeginDeletePrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginDeletePrivateEndpointConnection(ctx, "rg", "testSite", "connection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSitePrivateLinkResources.json
func ExampleWebAppsClient_GetPrivateLinkResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetPrivateLinkResources(ctx, "rg", "testSite", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateLinkResourcesWrapper = armappservice.PrivateLinkResourcesWrapper{
	// 	Value: []*armappservice.PrivateLinkResource{
	// 		{
	// 			Name: to.Ptr("site"),
	// 			Type: to.Ptr("Microsoft.Web/sites/privateLinkResources"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/privateLinkResources/site"),
	// 			Properties: &armappservice.PrivateLinkResourceProperties{
	// 				GroupID: to.Ptr("sites"),
	// 				RequiredMembers: []*string{
	// 					to.Ptr("sites")},
	// 					RequiredZoneNames: []*string{
	// 						to.Ptr("privatelink.testsite.azurewebsites.net")},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListWebAppSlots.json
func ExampleWebAppsClient_NewListSlotsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListSlotsPager("testrg123", "sitef6141", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppCollection = armappservice.WebAppCollection{
		// 	Value: []*armappservice.Site{
		// 		{
		// 			Name: to.Ptr("sitef6141/staging"),
		// 			Type: to.Ptr("Microsoft.Web/sites/slots"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/slots/staging"),
		// 			Kind: to.Ptr("app"),
		// 			Location: to.Ptr("East US"),
		// 			Properties: &armappservice.SiteProperties{
		// 				AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
		// 				ClientAffinityEnabled: to.Ptr(true),
		// 				ClientCertEnabled: to.Ptr(false),
		// 				ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
		// 				ContainerSize: to.Ptr[int32](0),
		// 				CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
		// 				DailyMemoryTimeQuota: to.Ptr[int32](0),
		// 				DefaultHostName: to.Ptr("sitef6141-staging.azurewebsites.net"),
		// 				Enabled: to.Ptr(true),
		// 				EnabledHostNames: []*string{
		// 					to.Ptr("sitef6141-staging.azurewebsites.net"),
		// 					to.Ptr("sitef6141-staging.scm.azurewebsites.net")},
		// 					HostNameSSLStates: []*armappservice.HostNameSSLState{
		// 						{
		// 							Name: to.Ptr("sitef6141-staging.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeStandard),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 						},
		// 						{
		// 							Name: to.Ptr("sitef6141-staging.scm.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeRepository),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 					}},
		// 					HostNames: []*string{
		// 						to.Ptr("sitef6141-staging.azurewebsites.net")},
		// 						HostNamesDisabled: to.Ptr(false),
		// 						HTTPSOnly: to.Ptr(false),
		// 						HyperV: to.Ptr(false),
		// 						IsXenon: to.Ptr(false),
		// 						KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
		// 						LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
		// 						OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
		// 						PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
		// 						RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
		// 						RepositorySiteName: to.Ptr("sitef6141"),
		// 						Reserved: to.Ptr(false),
		// 						ResourceGroup: to.Ptr("testrg123"),
		// 						ScmSiteAlsoStopped: to.Ptr(false),
		// 						ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		// 						SiteConfig: &armappservice.SiteConfig{
		// 							AcrUseManagedIdentityCreds: to.Ptr(false),
		// 							AlwaysOn: to.Ptr(false),
		// 							AppCommandLine: to.Ptr(""),
		// 							AutoHealEnabled: to.Ptr(false),
		// 							AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
		// 							},
		// 							DefaultDocuments: []*string{
		// 								to.Ptr("Default.htm"),
		// 								to.Ptr("Default.html"),
		// 								to.Ptr("Default.asp"),
		// 								to.Ptr("index.htm"),
		// 								to.Ptr("index.html"),
		// 								to.Ptr("iisstart.htm"),
		// 								to.Ptr("default.aspx"),
		// 								to.Ptr("index.php"),
		// 								to.Ptr("hostingstart.html")},
		// 								DetailedErrorLoggingEnabled: to.Ptr(false),
		// 								FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
		// 								FunctionAppScaleLimit: to.Ptr[int32](0),
		// 								FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
		// 								Http20Enabled: to.Ptr(false),
		// 								HTTPLoggingEnabled: to.Ptr(false),
		// 								LinuxFxVersion: to.Ptr(""),
		// 								LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
		// 								LogsDirectorySizeLimit: to.Ptr[int32](35),
		// 								ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
		// 								MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 								MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 								NetFrameworkVersion: to.Ptr("v4.0"),
		// 								NodeVersion: to.Ptr(""),
		// 								NumberOfWorkers: to.Ptr[int32](1),
		// 								PhpVersion: to.Ptr("5.6"),
		// 								PowerShellVersion: to.Ptr(""),
		// 								PythonVersion: to.Ptr(""),
		// 								RemoteDebuggingEnabled: to.Ptr(false),
		// 								RequestTracingEnabled: to.Ptr(false),
		// 								ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 								Use32BitWorkerProcess: to.Ptr(true),
		// 								VirtualApplications: []*armappservice.VirtualApplication{
		// 									{
		// 										PhysicalPath: to.Ptr("site\\wwwroot"),
		// 										PreloadEnabled: to.Ptr(false),
		// 										VirtualPath: to.Ptr("/"),
		// 								}},
		// 								VnetName: to.Ptr(""),
		// 								VnetPrivatePortsCount: to.Ptr[int32](0),
		// 								VnetRouteAllEnabled: to.Ptr(false),
		// 								WebSocketsEnabled: to.Ptr(false),
		// 							},
		// 							State: to.Ptr("Running"),
		// 							StorageAccountRequired: to.Ptr(false),
		// 							UsageState: to.Ptr(armappservice.UsageStateNormal),
		// 							VnetContentShareEnabled: to.Ptr(false),
		// 							VnetImagePullEnabled: to.Ptr(false),
		// 							VnetRouteAllEnabled: to.Ptr(false),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("sitef6141/qa"),
		// 						Type: to.Ptr("Microsoft.Web/sites/slots"),
		// 						ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/slots/qa"),
		// 						Kind: to.Ptr("app"),
		// 						Location: to.Ptr("East US"),
		// 						Properties: &armappservice.SiteProperties{
		// 							AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
		// 							ClientAffinityEnabled: to.Ptr(true),
		// 							ClientCertEnabled: to.Ptr(false),
		// 							ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
		// 							ContainerSize: to.Ptr[int32](0),
		// 							CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
		// 							DailyMemoryTimeQuota: to.Ptr[int32](0),
		// 							DefaultHostName: to.Ptr("sitef6141-qa.azurewebsites.net"),
		// 							Enabled: to.Ptr(true),
		// 							EnabledHostNames: []*string{
		// 								to.Ptr("sitef6141-staging.azurewebsites.net"),
		// 								to.Ptr("sitef6141-staging.scm.azurewebsites.net")},
		// 								HostNameSSLStates: []*armappservice.HostNameSSLState{
		// 									{
		// 										Name: to.Ptr("sitef6141-qa.azurewebsites.net"),
		// 										HostType: to.Ptr(armappservice.HostTypeStandard),
		// 										SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 									},
		// 									{
		// 										Name: to.Ptr("sitef6141-qa.scm.azurewebsites.net"),
		// 										HostType: to.Ptr(armappservice.HostTypeRepository),
		// 										SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 								}},
		// 								HostNames: []*string{
		// 									to.Ptr("sitef6141-qa.azurewebsites.net")},
		// 									HostNamesDisabled: to.Ptr(false),
		// 									HTTPSOnly: to.Ptr(false),
		// 									HyperV: to.Ptr(false),
		// 									IsXenon: to.Ptr(false),
		// 									KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
		// 									LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
		// 									OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
		// 									PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
		// 									RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
		// 									RepositorySiteName: to.Ptr("sitef6141"),
		// 									Reserved: to.Ptr(false),
		// 									ResourceGroup: to.Ptr("testrg123"),
		// 									ScmSiteAlsoStopped: to.Ptr(false),
		// 									ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		// 									SiteConfig: &armappservice.SiteConfig{
		// 										AcrUseManagedIdentityCreds: to.Ptr(false),
		// 										AlwaysOn: to.Ptr(false),
		// 										AppCommandLine: to.Ptr(""),
		// 										AutoHealEnabled: to.Ptr(false),
		// 										AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
		// 										},
		// 										DefaultDocuments: []*string{
		// 											to.Ptr("Default.htm"),
		// 											to.Ptr("Default.html"),
		// 											to.Ptr("Default.asp"),
		// 											to.Ptr("index.htm"),
		// 											to.Ptr("index.html"),
		// 											to.Ptr("iisstart.htm"),
		// 											to.Ptr("default.aspx"),
		// 											to.Ptr("index.php"),
		// 											to.Ptr("hostingstart.html")},
		// 											DetailedErrorLoggingEnabled: to.Ptr(false),
		// 											FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
		// 											FunctionAppScaleLimit: to.Ptr[int32](0),
		// 											FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
		// 											Http20Enabled: to.Ptr(false),
		// 											HTTPLoggingEnabled: to.Ptr(false),
		// 											LinuxFxVersion: to.Ptr(""),
		// 											LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
		// 											LogsDirectorySizeLimit: to.Ptr[int32](35),
		// 											ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
		// 											MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 											MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 											NetFrameworkVersion: to.Ptr("v4.0"),
		// 											NodeVersion: to.Ptr(""),
		// 											NumberOfWorkers: to.Ptr[int32](1),
		// 											PhpVersion: to.Ptr("5.6"),
		// 											PowerShellVersion: to.Ptr(""),
		// 											PythonVersion: to.Ptr(""),
		// 											RemoteDebuggingEnabled: to.Ptr(false),
		// 											RequestTracingEnabled: to.Ptr(false),
		// 											ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
		// 											Use32BitWorkerProcess: to.Ptr(true),
		// 											VirtualApplications: []*armappservice.VirtualApplication{
		// 												{
		// 													PhysicalPath: to.Ptr("site\\wwwroot"),
		// 													PreloadEnabled: to.Ptr(false),
		// 													VirtualPath: to.Ptr("/"),
		// 											}},
		// 											VnetName: to.Ptr(""),
		// 											VnetPrivatePortsCount: to.Ptr[int32](0),
		// 											VnetRouteAllEnabled: to.Ptr(false),
		// 											WebSocketsEnabled: to.Ptr(false),
		// 										},
		// 										State: to.Ptr("Running"),
		// 										StorageAccountRequired: to.Ptr(false),
		// 										UsageState: to.Ptr(armappservice.UsageStateNormal),
		// 										VnetContentShareEnabled: to.Ptr(false),
		// 										VnetImagePullEnabled: to.Ptr(false),
		// 										VnetRouteAllEnabled: to.Ptr(false),
		// 									},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWebAppSlot.json
func ExampleWebAppsClient_GetSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetSlot(ctx, "testrg123", "sitef6141", "staging", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141/staging"),
	// 	Type: to.Ptr("Microsoft.Web/sites/slots"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/slots/staging"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 			to.Ptr("sitef6141-staging.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141-staging.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/CloneWebAppSlot.json
func ExampleWebAppsClient_BeginCreateOrUpdateSlot_cloneWebAppSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginCreateOrUpdateSlot(ctx, "testrg123", "sitef6141", "staging", armappservice.Site{
		Kind:     to.Ptr("app"),
		Location: to.Ptr("East US"),
		Properties: &armappservice.SiteProperties{
			CloningInfo: &armappservice.CloningInfo{
				AppSettingsOverrides: map[string]*string{
					"Setting1": to.Ptr("NewValue1"),
					"Setting3": to.Ptr("NewValue5"),
				},
				CloneCustomHostNames:   to.Ptr(true),
				CloneSourceControl:     to.Ptr(true),
				ConfigureLoadBalancing: to.Ptr(false),
				HostingEnvironment:     to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/hostingenvironments/aseforsites"),
				Overwrite:              to.Ptr(false),
				SourceWebAppID:         to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/sites/srcsiteg478/slot/qa"),
				SourceWebAppLocation:   to.Ptr("West Europe"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141/staging"),
	// 	Type: to.Ptr("Microsoft.Web/sites/slots"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/slots/staging"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 			to.Ptr("sitef6141-staging.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141-staging.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/CreateOrUpdateWebAppSlot.json
func ExampleWebAppsClient_BeginCreateOrUpdateSlot_createOrUpdateWebAppSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginCreateOrUpdateSlot(ctx, "testrg123", "sitef6141", "staging", armappservice.Site{
		Kind:     to.Ptr("app"),
		Location: to.Ptr("East US"),
		Properties: &armappservice.SiteProperties{
			ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141/staging"),
	// 	Type: to.Ptr("Microsoft.Web/sites/slots"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/slots/staging"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 			to.Ptr("sitef6141-staging.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141-staging.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/DeleteWebAppSlot.json
func ExampleWebAppsClient_DeleteSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().DeleteSlot(ctx, "testrg123", "sitef6141", "staging", &armappservice.WebAppsClientDeleteSlotOptions{DeleteMetrics: nil,
		DeleteEmptyServerFarm: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateWebAppSlot.json
func ExampleWebAppsClient_UpdateSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().UpdateSlot(ctx, "testrg123", "sitef6141", "staging", armappservice.SitePatchResource{
		Properties: &armappservice.SitePatchResourceProperties{
			ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Site = armappservice.Site{
	// 	Name: to.Ptr("sitef6141/staging"),
	// 	Type: to.Ptr("Microsoft.Web/sites/slots"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/slots/staging"),
	// 	Kind: to.Ptr("app"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armappservice.SiteProperties{
	// 		AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
	// 		ClientAffinityEnabled: to.Ptr(true),
	// 		ClientCertEnabled: to.Ptr(false),
	// 		ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
	// 		ContainerSize: to.Ptr[int32](0),
	// 		CustomDomainVerificationID: to.Ptr("7F3BB652450EF7AD0B6AA33064586E4A9CE823A46DF0B2EC6443A68086E84153"),
	// 		DailyMemoryTimeQuota: to.Ptr[int32](0),
	// 		DefaultHostName: to.Ptr("sitef6141.azurewebsites.net"),
	// 		Enabled: to.Ptr(true),
	// 		EnabledHostNames: []*string{
	// 			to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 			to.Ptr("sitef6141-staging.scm.azurewebsites.net")},
	// 			HostNameSSLStates: []*armappservice.HostNameSSLState{
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeStandard),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 				},
	// 				{
	// 					Name: to.Ptr("sitef6141-staging.scm.azurewebsites.net"),
	// 					HostType: to.Ptr(armappservice.HostTypeRepository),
	// 					SSLState: to.Ptr(armappservice.SSLStateDisabled),
	// 			}},
	// 			HostNames: []*string{
	// 				to.Ptr("sitef6141-staging.azurewebsites.net")},
	// 				HostNamesDisabled: to.Ptr(false),
	// 				HTTPSOnly: to.Ptr(false),
	// 				HyperV: to.Ptr(false),
	// 				IsXenon: to.Ptr(false),
	// 				KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
	// 				LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-04T17:33:11.641Z"); return t}()),
	// 				OutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144"),
	// 				PossibleOutboundIPAddresses: to.Ptr("70.37.102.201,20.225.43.144,20.225.184.122,20.225.184.188"),
	// 				RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
	// 				RepositorySiteName: to.Ptr("sitef6141"),
	// 				Reserved: to.Ptr(false),
	// 				ResourceGroup: to.Ptr("testrg123"),
	// 				ScmSiteAlsoStopped: to.Ptr(false),
	// 				ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
	// 				SiteConfig: &armappservice.SiteConfig{
	// 					AcrUseManagedIdentityCreds: to.Ptr(false),
	// 					AlwaysOn: to.Ptr(false),
	// 					AppCommandLine: to.Ptr(""),
	// 					AutoHealEnabled: to.Ptr(false),
	// 					AzureStorageAccounts: map[string]*armappservice.AzureStorageInfoValue{
	// 					},
	// 					DefaultDocuments: []*string{
	// 						to.Ptr("Default.htm"),
	// 						to.Ptr("Default.html"),
	// 						to.Ptr("Default.asp"),
	// 						to.Ptr("index.htm"),
	// 						to.Ptr("index.html"),
	// 						to.Ptr("iisstart.htm"),
	// 						to.Ptr("default.aspx"),
	// 						to.Ptr("index.php"),
	// 						to.Ptr("hostingstart.html")},
	// 						DetailedErrorLoggingEnabled: to.Ptr(false),
	// 						FtpsState: to.Ptr(armappservice.FtpsStateAllAllowed),
	// 						FunctionAppScaleLimit: to.Ptr[int32](0),
	// 						FunctionsRuntimeScaleMonitoringEnabled: to.Ptr(false),
	// 						Http20Enabled: to.Ptr(false),
	// 						HTTPLoggingEnabled: to.Ptr(false),
	// 						LinuxFxVersion: to.Ptr(""),
	// 						LoadBalancing: to.Ptr(armappservice.SiteLoadBalancingLeastRequests),
	// 						LogsDirectorySizeLimit: to.Ptr[int32](35),
	// 						ManagedPipelineMode: to.Ptr(armappservice.ManagedPipelineModeIntegrated),
	// 						MinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						MinimumElasticInstanceCount: to.Ptr[int32](0),
	// 						NetFrameworkVersion: to.Ptr("v4.0"),
	// 						NodeVersion: to.Ptr(""),
	// 						NumberOfWorkers: to.Ptr[int32](1),
	// 						PhpVersion: to.Ptr("5.6"),
	// 						PowerShellVersion: to.Ptr(""),
	// 						PythonVersion: to.Ptr(""),
	// 						RemoteDebuggingEnabled: to.Ptr(false),
	// 						RequestTracingEnabled: to.Ptr(false),
	// 						ScmMinTLSVersion: to.Ptr(armappservice.SupportedTLSVersionsOne2),
	// 						Use32BitWorkerProcess: to.Ptr(true),
	// 						VirtualApplications: []*armappservice.VirtualApplication{
	// 							{
	// 								PhysicalPath: to.Ptr("site\\wwwroot"),
	// 								PreloadEnabled: to.Ptr(false),
	// 								VirtualPath: to.Ptr("/"),
	// 						}},
	// 						VnetName: to.Ptr(""),
	// 						VnetPrivatePortsCount: to.Ptr[int32](0),
	// 						VnetRouteAllEnabled: to.Ptr(false),
	// 						WebSocketsEnabled: to.Ptr(false),
	// 					},
	// 					State: to.Ptr("Running"),
	// 					StorageAccountRequired: to.Ptr(false),
	// 					UsageState: to.Ptr(armappservice.UsageStateNormal),
	// 					VnetContentShareEnabled: to.Ptr(false),
	// 					VnetImagePullEnabled: to.Ptr(false),
	// 					VnetRouteAllEnabled: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AnalyzeCustomHostNameSlot.json
func ExampleWebAppsClient_AnalyzeCustomHostnameSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().AnalyzeCustomHostnameSlot(ctx, "testrg123", "sitef6141", "staging", &armappservice.WebAppsClientAnalyzeCustomHostnameSlotOptions{HostName: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomHostnameAnalysisResult = armappservice.CustomHostnameAnalysisResult{
	// 	Name: to.Ptr("sitef6141/staging"),
	// 	Type: to.Ptr("Microsoft.Web/sites/stagings"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/sitef6141/slots/staging"),
	// 	Properties: &armappservice.CustomHostnameAnalysisResultProperties{
	// 		CNameRecords: []*string{
	// 			to.Ptr("siteog.azurewebsites.net")},
	// 			ConflictingAppResourceID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/siteog/slots/qa"),
	// 			CustomDomainVerificationFailureInfo: &armappservice.ErrorEntity{
	// 				Code: to.Ptr("07198"),
	// 				Message: to.Ptr("Custom domain verification failed on conflicting CNAMEs."),
	// 			},
	// 			CustomDomainVerificationTest: to.Ptr(armappservice.DNSVerificationTestResultPassed),
	// 			HasConflictAcrossSubscription: to.Ptr(true),
	// 			HasConflictOnScaleUnit: to.Ptr(false),
	// 			IsHostnameAlreadyVerified: to.Ptr(true),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListPublishingCredentialsPoliciesSlot.json
func ExampleWebAppsClient_NewListBasicPublishingCredentialsPoliciesSlotPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListBasicPublishingCredentialsPoliciesSlotPager("testrg123", "testsite", "staging", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PublishingCredentialsPoliciesCollection = armappservice.PublishingCredentialsPoliciesCollection{
		// 	Value: []*armappservice.CsmPublishingCredentialsPoliciesEntity{
		// 		{
		// 			Name: to.Ptr("ftp"),
		// 			Type: to.Ptr("Microsoft.Web/sites/slots/basicPublishingCredentialsPolicies"),
		// 			ID: to.Ptr("/subscriptions/3fb8d758-2e2c-42e9-a528-a8acdfe87237/resourceGroups/testrg123/providers/Microsoft.Web/sites/testsite/slots/staging/basicPublishingCredentialsPolicies/ftp"),
		// 			Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
		// 				Allow: to.Ptr(true),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scm"),
		// 			Type: to.Ptr("Microsoft.Web/sites/slots/basicPublishingCredentialsPolicies"),
		// 			ID: to.Ptr("/subscriptions/3fb8d758-2e2c-42e9-a528-a8acdfe87237/resourceGroups/testrg123/providers/Microsoft.Web/sites/testsite/slots/staging/basicPublishingCredentialsPolicies/scm"),
		// 			Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
		// 				Allow: to.Ptr(true),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetPublishingCredentialsPolicySlot.json
func ExampleWebAppsClient_GetFtpAllowedSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetFtpAllowedSlot(ctx, "rg", "testSite", "stage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CsmPublishingCredentialsPoliciesEntity = armappservice.CsmPublishingCredentialsPoliciesEntity{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/slots/stage/basicPublishingCredentialsPolicies/ftp"),
	// 	Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
	// 		Allow: to.Ptr(false),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdatePublishingCredentialsPolicySlot.json
func ExampleWebAppsClient_UpdateFtpAllowedSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().UpdateFtpAllowedSlot(ctx, "rg", "testSite", "stage", armappservice.CsmPublishingCredentialsPoliciesEntity{
		Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
			Allow: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CsmPublishingCredentialsPoliciesEntity = armappservice.CsmPublishingCredentialsPoliciesEntity{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/slots/stage/basicPublishingCredentialsPolicies/ftp"),
	// 	Properties: &armappservice.CsmPublishingCredentialsPoliciesEntityProperties{
	// 		Allow: to.Ptr(true),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetKeyVaultReferencesForAppSettingsSlot.json
func ExampleWebAppsClient_NewGetAppSettingsKeyVaultReferencesSlotPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewGetAppSettingsKeyVaultReferencesSlotPager("testrg123", "testc6282", "stage", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.APIKVReferenceCollection = armappservice.APIKVReferenceCollection{
		// 	Value: []*armappservice.APIKVReference{
		// 		{
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testc6282/slots/stage/config/configreferences/appsettings/secretName"),
		// 			Properties: &armappservice.APIKVReferenceProperties{
		// 				SecretName: to.Ptr("secretName"),
		// 				SecretVersion: to.Ptr("secretVersion"),
		// 				VaultName: to.Ptr("keyVaultName"),
		// 			},
		// 		},
		// 		{
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testc6282/slots/stage/config/configreferences/appsettings/secretName2"),
		// 			Properties: &armappservice.APIKVReferenceProperties{
		// 				SecretName: to.Ptr("secretName2"),
		// 				SecretVersion: to.Ptr("secretVersion2"),
		// 				VaultName: to.Ptr("keyVaultName"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetKeyVaultReferencesForAppSettingSlot.json
func ExampleWebAppsClient_GetAppSettingKeyVaultReferenceSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetAppSettingKeyVaultReferenceSlot(ctx, "testrg123", "testc6282", "setting", "stage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.APIKVReference = armappservice.APIKVReference{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testc6282/slots/stage/config/configreferences/appsettings/setting"),
	// 	Properties: &armappservice.APIKVReferenceProperties{
	// 		SecretName: to.Ptr("secretName"),
	// 		SecretVersion: to.Ptr("secretVersion"),
	// 		VaultName: to.Ptr("keyVaultName"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListSiteDeploymentStatusSlot.json
func ExampleWebAppsClient_NewListSlotSiteDeploymentStatusesSlotPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListSlotSiteDeploymentStatusesSlotPager("rg", "testSite", "stage", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CsmDeploymentStatusCollection = armappservice.CsmDeploymentStatusCollection{
		// 	Value: []*armappservice.CsmDeploymentStatus{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSiteDeploymentStatusSlot.json
func ExampleWebAppsClient_BeginGetSlotSiteDeploymentStatusSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginGetSlotSiteDeploymentStatusSlot(ctx, "rg", "testSite", "stage", "eacfd68b-3bbd-4ad9-99c5-98614d89c8e5", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CsmDeploymentStatus = armappservice.CsmDeploymentStatus{
	// 	Name: to.Ptr("eacfd68b-3bbd-4ad9-99c5-98614d89c8e5"),
	// 	Type: to.Ptr("Microsoft.Web/sites/slots/deploymentStatus"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/slots/stage/deploymentStatus/eacfd68b-3bbd-4ad9-99c5-98614d89c8e5"),
	// 	Properties: &armappservice.CsmDeploymentStatusProperties{
	// 		DeploymentID: to.Ptr("eacfd68b-3bbd-4ad9-99c5-98614d89c8e5"),
	// 		FailedInstancesLogs: []*string{
	// 		},
	// 		NumberOfInstancesFailed: to.Ptr[int32](0),
	// 		NumberOfInstancesInProgress: to.Ptr[int32](0),
	// 		NumberOfInstancesSuccessful: to.Ptr[int32](1),
	// 		Status: to.Ptr(armappservice.DeploymentBuildStatusRuntimeSuccessful),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSitePrivateEndpointConnectionSlot.json
func ExampleWebAppsClient_GetPrivateEndpointConnectionSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetPrivateEndpointConnectionSlot(ctx, "rg", "testSite", "connection", "stage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemotePrivateEndpointConnectionARMResource = armappservice.RemotePrivateEndpointConnectionARMResource{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/slot/stage/privateEndpointConnections/connection"),
	// 	Properties: &armappservice.RemotePrivateEndpointConnectionARMResourceProperties{
	// 		PrivateEndpoint: &armappservice.ArmIDWrapper{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
	// 			Description: to.Ptr("Approved by admin."),
	// 			ActionsRequired: to.Ptr(""),
	// 			Status: to.Ptr("Approved"),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ApproveRejectSitePrivateEndpointConnectionSlot.json
func ExampleWebAppsClient_BeginApproveOrRejectPrivateEndpointConnectionSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginApproveOrRejectPrivateEndpointConnectionSlot(ctx, "rg", "testSite", "connection", "stage", armappservice.PrivateLinkConnectionApprovalRequestResource{
		Properties: &armappservice.PrivateLinkConnectionApprovalRequest{
			PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
				Description:     to.Ptr("Approved by admin."),
				ActionsRequired: to.Ptr(""),
				Status:          to.Ptr("Approved"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemotePrivateEndpointConnectionARMResource = armappservice.RemotePrivateEndpointConnectionARMResource{
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/slots/stage/privateEndpointConnections/connection"),
	// 	Properties: &armappservice.RemotePrivateEndpointConnectionARMResourceProperties{
	// 		PrivateEndpoint: &armappservice.ArmIDWrapper{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
	// 			Description: to.Ptr("Approved by admin."),
	// 			ActionsRequired: to.Ptr(""),
	// 			Status: to.Ptr("Approved"),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/DeleteSitePrivateEndpointConnectionSlot.json
func ExampleWebAppsClient_BeginDeletePrivateEndpointConnectionSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWebAppsClient().BeginDeletePrivateEndpointConnectionSlot(ctx, "rg", "testSite", "connection", "stage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetSitePrivateLinkResourcesSlot.json
func ExampleWebAppsClient_GetPrivateLinkResourcesSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetPrivateLinkResourcesSlot(ctx, "rg", "testSite", "stage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateLinkResourcesWrapper = armappservice.PrivateLinkResourcesWrapper{
	// 	Value: []*armappservice.PrivateLinkResource{
	// 		{
	// 			Name: to.Ptr("site"),
	// 			Type: to.Ptr("Microsoft.Web/sites/privateLinkResources"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/sites/testSite/privateLinkResources/site"),
	// 			Properties: &armappservice.PrivateLinkResourceProperties{
	// 				GroupID: to.Ptr("sites"),
	// 				RequiredMembers: []*string{
	// 					to.Ptr("sites")},
	// 					RequiredZoneNames: []*string{
	// 						to.Ptr("privatelink.testsite.azurewebsites.net")},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/DeleteDeployWorkflowArtifacts.json
func ExampleWebAppsClient_DeployWorkflowArtifacts_deleteWorkflowArtifacts() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().DeployWorkflowArtifacts(ctx, "testrg123", "testsite2", &armappservice.WebAppsClientDeployWorkflowArtifactsOptions{WorkflowArtifacts: &armappservice.WorkflowArtifacts{
		FilesToDelete: []*string{
			to.Ptr("test/workflow.json"),
			to.Ptr("test/")},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/PostDeployWorkflowArtifacts.json
func ExampleWebAppsClient_DeployWorkflowArtifacts_deploysWorkflowArtifacts() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().DeployWorkflowArtifacts(ctx, "testrg123", "testsite2", &armappservice.WebAppsClientDeployWorkflowArtifactsOptions{WorkflowArtifacts: &armappservice.WorkflowArtifacts{
		AppSettings: map[string]any{
			"eventHub_connectionString": "Endpoint=sb://example.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=EXAMPLE1a2b3c4d5e6fEXAMPLE=",
		},
		Files: map[string]any{
			"connections.json": map[string]any{
				"managedApiConnections": map[string]any{},
				"serviceProviderConnections": map[string]any{
					"eventHub": map[string]any{
						"displayName": "example1",
						"parameterValues": map[string]any{
							"connectionString": "@appsetting('eventHub_connectionString')",
						},
						"serviceProvider": map[string]any{
							"id": "/serviceProviders/eventHub",
						},
					},
				},
			},
			"test1/workflow.json": map[string]any{
				"definition": map[string]any{
					"$schema":        "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
					"actions":        map[string]any{},
					"contentVersion": "1.0.0.0",
					"outputs":        map[string]any{},
					"triggers": map[string]any{
						"When_events_are_available_in_Event_hub": map[string]any{
							"type": "ServiceProvider",
							"inputs": map[string]any{
								"parameters": map[string]any{
									"eventHubName": "test123",
								},
								"serviceProviderConfiguration": map[string]any{
									"operationId":       "receiveEvents",
									"connectionName":    "eventHub",
									"serviceProviderId": "/serviceProviders/eventHub",
								},
							},
							"splitOn": "@triggerOutputs()?['body']",
						},
					},
				},
				"kind": "Stateful",
			},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/PostDeployWorkflowArtifactsSlot.json
func ExampleWebAppsClient_DeployWorkflowArtifactsSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWebAppsClient().DeployWorkflowArtifactsSlot(ctx, "testrg123", "testsite2", "testsSlot", &armappservice.WebAppsClientDeployWorkflowArtifactsSlotOptions{WorkflowArtifacts: &armappservice.WorkflowArtifacts{
		AppSettings: map[string]any{
			"eventHub_connectionString": "Endpoint=sb://example.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=EXAMPLE1a2b3c4d5e6fEXAMPLE=",
		},
		Files: map[string]any{
			"connections.json": map[string]any{
				"managedApiConnections": map[string]any{},
				"serviceProviderConnections": map[string]any{
					"eventHub": map[string]any{
						"displayName": "example1",
						"parameterValues": map[string]any{
							"connectionString": "@appsetting('eventHub_connectionString')",
						},
						"serviceProvider": map[string]any{
							"id": "/serviceProviders/eventHub",
						},
					},
				},
			},
			"test1/workflow.json": map[string]any{
				"definition": map[string]any{
					"$schema":        "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
					"actions":        map[string]any{},
					"contentVersion": "1.0.0.0",
					"outputs":        map[string]any{},
					"triggers": map[string]any{
						"When_events_are_available_in_Event_hub": map[string]any{
							"type": "ServiceProvider",
							"inputs": map[string]any{
								"parameters": map[string]any{
									"eventHubName": "test123",
								},
								"serviceProviderConfiguration": map[string]any{
									"operationId":       "receiveEvents",
									"connectionName":    "eventHub",
									"serviceProviderId": "/serviceProviders/eventHub",
								},
							},
							"splitOn": "@triggerOutputs()?['body']",
						},
					},
				},
				"kind": "Stateful",
			},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListWorkflows.json
func ExampleWebAppsClient_NewListInstanceWorkflowsSlotPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWebAppsClient().NewListInstanceWorkflowsSlotPager("testrg123", "testsite2", "staging", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkflowEnvelopeCollection = armappservice.WorkflowEnvelopeCollection{
		// 	Value: []*armappservice.WorkflowEnvelope{
		// 		{
		// 			Name: to.Ptr("testsite2/a1"),
		// 			Type: to.Ptr("Microsoft.Web/sites/workflows"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testsite2/workflows/a1"),
		// 			Kind: to.Ptr("Stateful"),
		// 			Location: to.Ptr("USAAnywhere"),
		// 			Properties: &armappservice.WorkflowEnvelopeProperties{
		// 				FlowState: to.Ptr(armappservice.WorkflowStateEnabled),
		// 				Health: &armappservice.WorkflowHealth{
		// 					State: to.Ptr(armappservice.WorkflowHealthStateHealthy),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testsite2/stateful2"),
		// 			Type: to.Ptr("Microsoft.Web/sites/workflows"),
		// 			ID: to.Ptr("/subscriptions/testsub/resourceGroups/testrg/providers/Microsoft.Web/sites/testsite2/workflows/stateful2"),
		// 			Kind: to.Ptr("Stateful"),
		// 			Location: to.Ptr("USAAnywhere"),
		// 			Properties: &armappservice.WorkflowEnvelopeProperties{
		// 				FlowState: to.Ptr(armappservice.WorkflowStateEnabled),
		// 				Health: &armappservice.WorkflowHealth{
		// 					Error: &armappservice.ErrorEntity{
		// 						Code: to.Ptr("InvalidWorkflowJson"),
		// 						Message: to.Ptr("Invalid character after parsing property name. Expected ':' but got: \". Path '', line 2, position 2."),
		// 					},
		// 					State: to.Ptr(armappservice.WorkflowHealthStateUnhealthy),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetWorkflow.json
func ExampleWebAppsClient_GetInstanceWorkflowSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().GetInstanceWorkflowSlot(ctx, "testrg123", "testsite2", "staging", "stateful1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkflowEnvelope = armappservice.WorkflowEnvelope{
	// 	Name: to.Ptr("testsite2/stateful1"),
	// 	Type: to.Ptr("Microsoft.Web/sites/workflows"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testsite2/workflows/stateful1"),
	// 	Kind: to.Ptr("Stateful"),
	// 	Location: to.Ptr("USAAnywhere"),
	// 	Properties: &armappservice.WorkflowEnvelopeProperties{
	// 		Files: map[string]any{
	// 			"connections.json": map[string]any{
	// 				"managedApiConnections":map[string]any{
	// 					"office365":map[string]any{
	// 						"api":map[string]any{
	// 							"id": "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/office365",
	// 						},
	// 						"authentication":map[string]any{
	// 							"type": "Raw",
	// 							"parameter": "@appsetting('office365-connectionKey')",
	// 							"scheme": "Key",
	// 						},
	// 						"connection":map[string]any{
	// 							"id": "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/connections/office365-1",
	// 						},
	// 						"connectionRuntimeUrl": "string",
	// 					},
	// 				},
	// 			},
	// 			"workflow.json": map[string]any{
	// 				"definition":map[string]any{
	// 					"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
	// 					"actions":map[string]any{
	// 					},
	// 					"contentVersion": "1.0.0.0",
	// 					"outputs":map[string]any{
	// 					},
	// 					"parameters":map[string]any{
	// 					},
	// 					"triggers":map[string]any{
	// 					},
	// 				},
	// 			},
	// 		},
	// 		FlowState: to.Ptr(armappservice.WorkflowStateEnabled),
	// 		Health: &armappservice.WorkflowHealth{
	// 			State: to.Ptr(armappservice.WorkflowHealthStateHealthy),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/ListWorkflowsConfigurationConnections.json
func ExampleWebAppsClient_ListWorkflowsConnectionsSlot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWebAppsClient().ListWorkflowsConnectionsSlot(ctx, "testrg123", "testsite2", "staging", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkflowEnvelope = armappservice.WorkflowEnvelope{
	// 	Name: to.Ptr("testsite2/connections"),
	// 	Type: to.Ptr("Microsoft.Web/sites/workflowsconfiguration"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/sites/testsite2/workflowconfigurations/connections"),
	// 	Location: to.Ptr("USAAnywhere"),
	// 	Properties: &armappservice.WorkflowEnvelopeProperties{
	// 		Files: map[string]any{
	// 			"connections.json": map[string]any{
	// 				"managedApiConnections":map[string]any{
	// 					"office365":map[string]any{
	// 						"api":map[string]any{
	// 							"id": "string",
	// 						},
	// 						"authentication":map[string]any{
	// 							"type": "Raw",
	// 							"parameter": "@appsetting('office365-connectionKey')",
	// 							"scheme": "Key",
	// 						},
	// 						"connection":map[string]any{
	// 							"id": "string",
	// 						},
	// 						"connectionRuntimeUrl": "string",
	// 					},
	// 				},
	// 			},
	// 		},
	// 		Health: &armappservice.WorkflowHealth{
	// 			State: to.Ptr(armappservice.WorkflowHealthStateHealthy),
	// 		},
	// 	},
	// }
}
