//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappplatform_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/ApplicationAccelerators_List.json
func ExampleApplicationAcceleratorsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationAcceleratorsClient().NewListPager("myResourceGroup", "myservice", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ApplicationAcceleratorResourceCollection = armappplatform.ApplicationAcceleratorResourceCollection{
		// 	Value: []*armappplatform.ApplicationAcceleratorResource{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.AppPlatform/Spring/applicationAccelerators"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/applicationAccelerators/default"),
		// 			SystemData: &armappplatform.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
		// 				CreatedBy: to.Ptr("sample-user"),
		// 				CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sample-user"),
		// 				LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
		// 			},
		// 			Properties: &armappplatform.ApplicationAcceleratorProperties{
		// 				Components: []*armappplatform.ApplicationAcceleratorComponent{
		// 					{
		// 						Name: to.Ptr("component1"),
		// 						Instances: []*armappplatform.ApplicationAcceleratorInstance{
		// 							{
		// 								Name: to.Ptr("instance1"),
		// 								Status: to.Ptr("Running"),
		// 						}},
		// 						ResourceRequests: &armappplatform.ApplicationAcceleratorResourceRequests{
		// 							CPU: to.Ptr("1"),
		// 							InstanceCount: to.Ptr[int32](1),
		// 							Memory: to.Ptr("1Gi"),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr(armappplatform.ApplicationAcceleratorProvisioningStateSucceeded),
		// 			},
		// 			SKU: &armappplatform.SKU{
		// 				Name: to.Ptr("E0"),
		// 				Capacity: to.Ptr[int32](2),
		// 				Tier: to.Ptr("Enterprise"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/ApplicationAccelerators_Get.json
func ExampleApplicationAcceleratorsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationAcceleratorsClient().Get(ctx, "myResourceGroup", "myservice", "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationAcceleratorResource = armappplatform.ApplicationAcceleratorResource{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/applicationAccelerators"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/applicationAccelerators/default"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.ApplicationAcceleratorProperties{
	// 		Components: []*armappplatform.ApplicationAcceleratorComponent{
	// 			{
	// 				Name: to.Ptr("component1"),
	// 				Instances: []*armappplatform.ApplicationAcceleratorInstance{
	// 					{
	// 						Name: to.Ptr("instance1"),
	// 						Status: to.Ptr("Running"),
	// 				}},
	// 				ResourceRequests: &armappplatform.ApplicationAcceleratorResourceRequests{
	// 					CPU: to.Ptr("1"),
	// 					InstanceCount: to.Ptr[int32](1),
	// 					Memory: to.Ptr("1Gi"),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.ApplicationAcceleratorProvisioningStateSucceeded),
	// 	},
	// 	SKU: &armappplatform.SKU{
	// 		Name: to.Ptr("E0"),
	// 		Capacity: to.Ptr[int32](2),
	// 		Tier: to.Ptr("Enterprise"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/ApplicationAccelerators_CreateOrUpdate.json
func ExampleApplicationAcceleratorsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationAcceleratorsClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myservice", "default", armappplatform.ApplicationAcceleratorResource{
		Properties: &armappplatform.ApplicationAcceleratorProperties{},
		SKU: &armappplatform.SKU{
			Name:     to.Ptr("E0"),
			Capacity: to.Ptr[int32](2),
			Tier:     to.Ptr("Enterprise"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationAcceleratorResource = armappplatform.ApplicationAcceleratorResource{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/applicationAccelerators"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/applicationAccelerators/default"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.ApplicationAcceleratorProperties{
	// 		Components: []*armappplatform.ApplicationAcceleratorComponent{
	// 			{
	// 				Name: to.Ptr("component1"),
	// 				Instances: []*armappplatform.ApplicationAcceleratorInstance{
	// 					{
	// 						Name: to.Ptr("instance1"),
	// 						Status: to.Ptr("Running"),
	// 				}},
	// 				ResourceRequests: &armappplatform.ApplicationAcceleratorResourceRequests{
	// 					CPU: to.Ptr("1"),
	// 					InstanceCount: to.Ptr[int32](1),
	// 					Memory: to.Ptr("1Gi"),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.ApplicationAcceleratorProvisioningStateSucceeded),
	// 	},
	// 	SKU: &armappplatform.SKU{
	// 		Name: to.Ptr("E0"),
	// 		Capacity: to.Ptr[int32](2),
	// 		Tier: to.Ptr("Enterprise"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appplatform/resource-manager/Microsoft.AppPlatform/preview/2023-01-01-preview/examples/ApplicationAccelerators_Delete.json
func ExampleApplicationAcceleratorsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationAcceleratorsClient().BeginDelete(ctx, "myResourceGroup", "myservice", "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
